/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.audio;

import com.almasb.fxgl.audio.Audio;
import com.almasb.fxgl.audio.AudioPlayer;
import com.almasb.fxgl.audio.AudioType;
import com.almasb.fxgl.audio.Music;
import com.almasb.fxgl.audio.Sound;
import com.almasb.fxgl.audio.impl.DesktopAndMobileAudioLoader;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.collection.UnorderedArray;
import com.almasb.fxgl.logging.Logger;
import java.net.URL;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\b\u0010\u001b\u001a\u00020\u0019H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\b\u0010\u001d\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0006\u0010!\u001a\u00020\u0019J\u000e\u0010\"\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010#\u001a\u00020\u0019J\u000e\u0010$\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u0019J\u000e\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u0006\u0010)\u001a\u00020\u0019J\u0006\u0010*\u001a\u00020\u0019J\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005J\u000e\u0010-\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/almasb/fxgl/audio/AudioPlayer;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "activeMusic", "Lcom/almasb/fxgl/core/collection/UnorderedArray;", "Lcom/almasb/fxgl/audio/Music;", "activeSounds", "Lcom/almasb/fxgl/audio/Sound;", "isPauseMusicWhenMinimized", "", "loader", "Lcom/almasb/fxgl/audio/impl/DesktopAndMobileAudioLoader;", "log", "Lcom/almasb/fxgl/logging/Logger;", "musicVolume", "Ljavafx/beans/property/DoubleProperty;", "soundVolume", "loadAudio", "Lcom/almasb/fxgl/audio/Audio;", "audioType", "Lcom/almasb/fxgl/audio/AudioType;", "url", "Ljava/net/URL;", "isMobile", "loopMusic", "", "music", "onMainLoopPausing", "onMainLoopResumed", "onMainLoopStarting", "onUpdate", "tpf", "", "pauseAllMusic", "pauseMusic", "playAllMusic", "playMusic", "playSound", "sound", "resumeAllMusic", "resumeMusic", "stopAllMusic", "stopAllSounds", "stopAllSoundsAndMusic", "stopMusic", "stopSound", "fxgl-core"})
@SourceDebugExtension(value={"SMAP\nAudioPlayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioPlayer.kt\ncom/almasb/fxgl/audio/AudioPlayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,195:1\n1855#2,2:196\n1855#2,2:198\n1855#2,2:200\n1855#2,2:202\n1855#2,2:204\n*S KotlinDebug\n*F\n+ 1 AudioPlayer.kt\ncom/almasb/fxgl/audio/AudioPlayer\n*L\n94#1:196,2\n159#1:198,2\n166#1:200,2\n173#1:202,2\n180#1:204,2\n*E\n"})
public final class AudioPlayer
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    @NotNull
    private final UnorderedArray<Music> activeMusic = new UnorderedArray(0, 1, null);
    @NotNull
    private final UnorderedArray<Sound> activeSounds = new UnorderedArray(0, 1, null);
    @Inject(value="globalMusicVolumeProperty")
    private DoubleProperty musicVolume;
    @Inject(value="globalSoundVolumeProperty")
    private DoubleProperty soundVolume;
    @Inject(value="isPauseMusicWhenMinimized")
    private boolean isPauseMusicWhenMinimized = true;
    @NotNull
    private final DesktopAndMobileAudioLoader loader = new DesktopAndMobileAudioLoader();

    @Override
    public void onMainLoopStarting() {
        DoubleProperty doubleProperty = this.musicVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException("musicVolume");
            doubleProperty = null;
        }
        doubleProperty.addListener((arg_0, arg_1, arg_2) -> AudioPlayer.onMainLoopStarting$lambda$0(new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(this){
            final /* synthetic */ AudioPlayer this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number newVolume) {
                Iterable $this$forEach$iv = AudioPlayer.access$getActiveMusic$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Music it = (Music)element$iv;
                    boolean bl = false;
                    it.getAudio().setVolume(newVolume.doubleValue());
                }
            }
        }, arg_0, arg_1, arg_2));
        DoubleProperty doubleProperty2 = this.soundVolume;
        if (doubleProperty2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("soundVolume");
            doubleProperty2 = null;
        }
        doubleProperty2.addListener((arg_0, arg_1, arg_2) -> AudioPlayer.onMainLoopStarting$lambda$1(new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(this){
            final /* synthetic */ AudioPlayer this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number newVolume) {
                Iterable $this$forEach$iv = AudioPlayer.access$getActiveSounds$p(this.this$0);
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    Sound it = (Sound)element$iv;
                    boolean bl = false;
                    it.getAudio().setVolume(newVolume.doubleValue());
                }
            }
        }, arg_0, arg_1, arg_2));
    }

    @Override
    public void onMainLoopPausing() {
        if (this.isPauseMusicWhenMinimized) {
            this.pauseAllMusic();
        }
    }

    @Override
    public void onMainLoopResumed() {
        if (this.isPauseMusicWhenMinimized) {
            this.resumeAllMusic();
        }
    }

    @Override
    public void onUpdate(double tpf) {
        CollectionsKt.removeAll((Iterable)this.activeMusic, (Function1)onUpdate.1.INSTANCE);
        CollectionsKt.removeAll((Iterable)this.activeSounds, (Function1)onUpdate.2.INSTANCE);
    }

    public final void playSound(@NotNull Sound sound) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        if (!this.activeSounds.containsByIdentity(sound)) {
            this.activeSounds.add(sound);
        }
        Audio audio2 = sound.getAudio();
        DoubleProperty doubleProperty = this.soundVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException("soundVolume");
            doubleProperty = null;
        }
        Double d = doubleProperty.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "soundVolume.value");
        audio2.setVolume(((Number)d).doubleValue());
        sound.getAudio().play();
    }

    public final void stopSound(@NotNull Sound sound) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        sound.getAudio().stop();
    }

    public final void stopAllSounds() {
        Iterable $this$forEach$iv = this.activeSounds;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Sound it = (Sound)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.stopSound(it);
        }
    }

    public final void playMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter(music, "music");
        this.log.debug("Playing music " + music);
        if (!this.activeMusic.containsByIdentity(music)) {
            this.activeMusic.add(music);
        }
        Audio audio2 = music.getAudio();
        DoubleProperty doubleProperty = this.musicVolume;
        if (doubleProperty == null) {
            Intrinsics.throwUninitializedPropertyAccessException("musicVolume");
            doubleProperty = null;
        }
        Double d = doubleProperty.getValue();
        Intrinsics.checkNotNullExpressionValue(d, "musicVolume.value");
        audio2.setVolume(((Number)d).doubleValue());
        music.getAudio().play();
    }

    public final void pauseMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter(music, "music");
        this.log.debug("Pausing music " + music);
        music.getAudio().pause();
    }

    public final void resumeMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter(music, "music");
        this.log.debug("Resuming music " + music);
        music.getAudio().play();
    }

    public final void stopMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter(music, "music");
        this.log.debug("Stopping music " + music);
        music.getAudio().stop();
    }

    public final void loopMusic(@NotNull Music music) {
        Intrinsics.checkNotNullParameter(music, "music");
        music.getAudio().setLooping(true);
        this.playMusic(music);
    }

    public final void pauseAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.pauseMusic(it);
        }
    }

    public final void resumeAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.resumeMusic(it);
        }
    }

    public final void playAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.playMusic(it);
        }
    }

    public final void stopAllMusic() {
        Iterable $this$forEach$iv = this.activeMusic;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Music it = (Music)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(it, "it");
            this.stopMusic(it);
        }
    }

    public final void stopAllSoundsAndMusic() {
        this.stopAllSounds();
        this.stopAllMusic();
    }

    @NotNull
    public final Audio loadAudio(@NotNull AudioType audioType, @NotNull URL url, boolean isMobile) {
        Intrinsics.checkNotNullParameter((Object)audioType, "audioType");
        Intrinsics.checkNotNullParameter(url, "url");
        return this.loader.loadAudio(audioType, url, isMobile);
    }

    private static final void onMainLoopStarting$lambda$0(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    private static final void onMainLoopStarting$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    public static final /* synthetic */ UnorderedArray access$getActiveMusic$p(AudioPlayer $this) {
        return $this.activeMusic;
    }

    public static final /* synthetic */ UnorderedArray access$getActiveSounds$p(AudioPlayer $this) {
        return $this.activeSounds;
    }
}

