/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.services;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.RuntimeInfo;
import com.almasb.fxgl.app.services.IOTaskExecutorService;
import com.almasb.fxgl.core.EngineService;
import com.almasb.fxgl.core.Inject;
import com.almasb.fxgl.core.concurrent.IOTask;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.net.NetService;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0013\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\r\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016R\u0012\u0010\u0003\u001a\u00020\u00048\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u00020\u000e8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/almasb/fxgl/app/services/UpdaterService;", "Lcom/almasb/fxgl/core/EngineService;", "()V", "appMode", "Lcom/almasb/fxgl/app/ApplicationMode;", "log", "Lcom/almasb/fxgl/logging/Logger;", "netService", "Lcom/almasb/fxgl/net/NetService;", "runtimeInfo", "Lcom/almasb/fxgl/app/RuntimeInfo;", "taskService", "Lcom/almasb/fxgl/app/services/IOTaskExecutorService;", "urlPOM", "", "checkForUpdates", "", "getLatestVersionTask", "Lcom/almasb/fxgl/core/concurrent/IOTask;", "getLatestVersionTask$fxgl", "needCheckForUpdate", "", "needCheckForUpdate$fxgl", "onInit", "fxgl"})
@SourceDebugExtension(value={"SMAP\nUpdaterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdaterService.kt\ncom/almasb/fxgl/app/services/UpdaterService\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,83:1\n52#2:84\n1#3:85\n123#4,2:86\n*S KotlinDebug\n*F\n+ 1 UpdaterService.kt\ncom/almasb/fxgl/app/services/UpdaterService\n*L\n77#1:84\n77#1:85\n78#1:86,2\n*E\n"})
public final class UpdaterService
extends EngineService {
    @NotNull
    private final Logger log = Logger.Companion.get(this.getClass());
    private NetService netService;
    private IOTaskExecutorService taskService;
    @Inject(value="applicationMode")
    private ApplicationMode appMode;
    @Inject(value="runtimeInfo")
    private RuntimeInfo runtimeInfo;
    @Inject(value="urlPOM")
    private String urlPOM;

    @Override
    public void onInit() {
        if (this.needCheckForUpdate$fxgl()) {
            this.checkForUpdates();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean needCheckForUpdate$fxgl() {
        ApplicationMode applicationMode = this.appMode;
        if (applicationMode == null) {
            Intrinsics.throwUninitializedPropertyAccessException("appMode");
            applicationMode = null;
        }
        if (applicationMode == ApplicationMode.RELEASE) return false;
        RuntimeInfo runtimeInfo = this.runtimeInfo;
        if (runtimeInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("runtimeInfo");
            runtimeInfo = null;
        }
        if (StringsKt.contains$default((CharSequence)runtimeInfo.getVersion(), "project.version", false, 2, null)) return false;
        return true;
    }

    private final void checkForUpdates() {
        this.log.debug("Checking for updates");
        IOTask<String> task2 = this.getLatestVersionTask$fxgl().onSuccess(arg_0 -> UpdaterService.checkForUpdates$lambda$0(this, arg_0)).onFailure(arg_0 -> UpdaterService.checkForUpdates$lambda$1(this, arg_0));
        IOTaskExecutorService iOTaskExecutorService = this.taskService;
        if (iOTaskExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("taskService");
            iOTaskExecutorService = null;
        }
        Intrinsics.checkNotNullExpressionValue(task2, "task");
        iOTaskExecutorService.runAsync(task2);
    }

    @NotNull
    public final IOTask<String> getLatestVersionTask$fxgl() {
        String string;
        NetService netService = this.netService;
        if (netService == null) {
            Intrinsics.throwUninitializedPropertyAccessException("netService");
            netService = null;
        }
        if ((string = this.urlPOM) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("urlPOM");
            string = null;
        }
        IOTask<String> iOTask = netService.openStreamTask(string).thenWrap(UpdaterService::getLatestVersionTask$lambda$4);
        Intrinsics.checkNotNullExpressionValue(iOTask, "netService\n            .\u2026          }\n            }");
        return iOTask;
    }

    private static final void checkForUpdates$lambda$0(UpdaterService this$0, String latestVersion) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        RuntimeInfo runtimeInfo = this$0.runtimeInfo;
        if (runtimeInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException("runtimeInfo");
            runtimeInfo = null;
        }
        if (!Intrinsics.areEqual(runtimeInfo.getVersion(), latestVersion)) {
            Logger logger = this$0.log;
            RuntimeInfo runtimeInfo2 = this$0.runtimeInfo;
            if (runtimeInfo2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("runtimeInfo");
                runtimeInfo2 = null;
            }
            logger.info("Your current version:  " + runtimeInfo2.getVersion());
            this$0.log.info("Latest stable version: " + latestVersion);
        }
    }

    private static final void checkForUpdates$lambda$1(UpdaterService this$0, Throwable error) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.log.warning("Failed to find updates: " + error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getLatestVersionTask$lambda$4(InputStream it) {
        String string;
        Intrinsics.checkNotNullExpressionValue(it, "it");
        InputStream inputStream = it;
        Charset charset = Charsets.UTF_8;
        Reader $this$useLines$iv = new InputStreamReader(inputStream, charset);
        boolean $i$f$useLines = false;
        Closeable closeable = $this$useLines$iv;
        int n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            String element$iv;
            block6: {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence<String> lines = TextStreamsKt.lineSequence(it$iv);
                boolean bl2 = false;
                Sequence<String> $this$first$iv = lines;
                boolean $i$f$first = false;
                Iterator<String> iterator2 = $this$first$iv.iterator();
                while (iterator2.hasNext()) {
                    String it2 = element$iv = iterator2.next();
                    boolean bl3 = false;
                    if (!StringsKt.contains$default((CharSequence)it2, "<version>", false, 2, null)) continue;
                    break block6;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            string = StringsKt.removeSurrounding(((Object)StringsKt.trim((CharSequence)element$iv)).toString(), (CharSequence)"<version>", (CharSequence)"</version>");
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return string;
    }
}

