/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.scene.Camera3D;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.GameScene;
import com.almasb.fxgl.app.scene.GameView;
import com.almasb.fxgl.core.concurrent.Async;
import com.almasb.fxgl.core.math.FXGLMath;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.EntityWorldListener;
import com.almasb.fxgl.entity.GameWorld;
import com.almasb.fxgl.entity.components.ViewComponent;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.physics.PhysicsWorld;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.ui.UI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Cursor;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SceneAntialiasing;
import javafx.scene.SubScene;
import javafx.scene.input.MouseEvent;
import javafx.scene.robot.Robot;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0015\u0018\u0000 g2\u00020\u00012\u00020\u0002:\u0002ghB1\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u000e\u0010>\u001a\u00020;2\u0006\u0010?\u001a\u00020@J\u000e\u0010A\u001a\u00020;2\u0006\u0010B\u001a\u000203J\u001f\u0010C\u001a\u00020;2\u0012\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u0002030E\"\u000203\u00a2\u0006\u0002\u0010FJ\u0006\u0010G\u001a\u00020;J\u0006\u0010H\u001a\u00020;J\u0010\u0010I\u001a\u00020;2\u0006\u0010J\u001a\u00020KH\u0002J\u0010\u0010L\u001a\u00020;2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010M\u001a\u00020;2\u0006\u0010N\u001a\u00020'2\u0006\u0010O\u001a\u00020'H\u0002J\u0018\u0010P\u001a\u00020Q2\u0006\u0010N\u001a\u00020'2\u0006\u0010O\u001a\u00020'H\u0002J\u0010\u0010R\u001a\u00020;2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020;2\u0006\u0010V\u001a\u00020\u0015H\u0016J\u0010\u0010W\u001a\u00020;2\u0006\u0010V\u001a\u00020\u0015H\u0016J\u0010\u0010X\u001a\u00020;2\u0006\u0010Y\u001a\u00020TH\u0016J\u0010\u0010Z\u001a\u00020;2\u0006\u0010[\u001a\u00020'H\u0014J\u000e\u0010\\\u001a\u00020;2\u0006\u0010<\u001a\u00020=J\u000e\u0010]\u001a\u00020;2\u0006\u0010?\u001a\u00020@J\u000e\u0010^\u001a\u00020\u000b2\u0006\u0010_\u001a\u000203J\u001f\u0010`\u001a\u00020;2\u0012\u0010D\u001a\n\u0012\u0006\b\u0001\u0012\u0002030E\"\u000203\u00a2\u0006\u0002\u0010FJ\r\u0010a\u001a\u00020;H\u0000\u00a2\u0006\u0002\bbJ\u000e\u0010c\u001a\u00020;2\u0006\u0010d\u001a\u00020\u000bJ\b\u0010e\u001a\u00020;H\u0002J\u000e\u0010f\u001a\u00020;2\u0006\u0010[\u001a\u00020'R\u001b\u0010\r\u001a\u00020\u000e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\u0013\u001a\u0012\u0012\u0004\u0012\u00020\u00150\u0014j\b\u0012\u0004\u0012\u00020\u0015`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001e\"\u0004\b\"\u0010 R\u001a\u0010#\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001e\"\u0004\b$\u0010 R\u000e\u0010%\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R+\u0010)\u001a\u0012 +*\b\u0018\u00010*R\u00020\u00000*R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b.\u0010\u0012\u001a\u0004\b,\u0010-R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0017\u00101\u001a\b\u0012\u0004\u0012\u000203028G\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u000e\u00106\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020908X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene;", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "Lcom/almasb/fxgl/entity/EntityWorldListener;", "width", "", "height", "gameWorld", "Lcom/almasb/fxgl/entity/GameWorld;", "physicsWorld", "Lcom/almasb/fxgl/physics/PhysicsWorld;", "is3D", "", "(IILcom/almasb/fxgl/entity/GameWorld;Lcom/almasb/fxgl/physics/PhysicsWorld;Z)V", "camera3D", "Lcom/almasb/fxgl/app/scene/Camera3D;", "getCamera3D", "()Lcom/almasb/fxgl/app/scene/Camera3D;", "camera3D$delegate", "Lkotlin/Lazy;", "entities", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/entity/Entity;", "Lkotlin/collections/ArrayList;", "gameRoot", "Ljavafx/scene/Group;", "getGameWorld", "()Lcom/almasb/fxgl/entity/GameWorld;", "isCursorInvisibleNeeded", "value", "isFPSCamera", "()Z", "setFPSCamera", "(Z)V", "isMouseGrabbed", "setMouseGrabbed", "isSingleStep", "setSingleStep", "isZSortingNeeded", "lastMouseX", "", "lastMouseY", "mouseWarper", "Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "kotlin.jvm.PlatformType", "getMouseWarper", "()Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "mouseWarper$delegate", "getPhysicsWorld", "()Lcom/almasb/fxgl/physics/PhysicsWorld;", "uiNodes", "Ljavafx/collections/ObservableList;", "Ljavafx/scene/Node;", "getUINodes", "()Ljavafx/collections/ObservableList;", "uiRoot", "zChangeListener", "Ljavafx/beans/value/ChangeListener;", "", "addGameView", "", "view", "Lcom/almasb/fxgl/app/scene/GameView;", "addUI", "ui", "Lcom/almasb/fxgl/ui/UI;", "addUINode", "node", "addUINodes", "nodes", "", "([Ljavafx/scene/Node;)V", "clearGameViews", "clearUINodes", "destroyView", "viewComponent", "Lcom/almasb/fxgl/entity/components/ViewComponent;", "initView", "initViewport", "w", "h", "make3DSubScene", "Ljavafx/scene/SubScene;", "onEnteredFrom", "prevState", "Lcom/almasb/fxgl/scene/Scene;", "onEntityAdded", "entity", "onEntityRemoved", "onExitingTo", "nextState", "onUpdate", "tpf", "removeGameView", "removeUI", "removeUINode", "n", "removeUINodes", "reset", "reset$fxgl", "setUIMouseTransparent", "b", "sortZ", "step", "Companion", "MouseWarper", "fxgl"})
@SourceDebugExtension(value={"SMAP\nGameScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameScene.kt\ncom/almasb/fxgl/app/scene/GameScene\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,452:1\n1002#2,2:453\n*S KotlinDebug\n*F\n+ 1 GameScene.kt\ncom/almasb/fxgl/app/scene/GameScene\n*L\n331#1:453,2\n*E\n"})
public final class GameScene
extends FXGLScene
implements EntityWorldListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GameWorld gameWorld;
    @NotNull
    private final PhysicsWorld physicsWorld;
    private final boolean is3D;
    @NotNull
    private final Group gameRoot;
    @NotNull
    private final Group uiRoot;
    @NotNull
    private final ArrayList<Entity> entities;
    private boolean isZSortingNeeded;
    @NotNull
    private final ChangeListener<Number> zChangeListener;
    private boolean isSingleStep;
    @NotNull
    private final Lazy camera3D$delegate;
    @NotNull
    private final Lazy mouseWarper$delegate;
    private boolean isMouseGrabbed;
    private boolean isFPSCamera;
    private double lastMouseX;
    private double lastMouseY;
    private boolean isCursorInvisibleNeeded;
    @NotNull
    private static final Logger log = Logger.Companion.get(GameScene.class);

    @JvmOverloads
    public GameScene(int width, int height, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld, boolean is3D) {
        Intrinsics.checkNotNullParameter(gameWorld, "gameWorld");
        Intrinsics.checkNotNullParameter(physicsWorld, "physicsWorld");
        super(width, height);
        this.gameWorld = gameWorld;
        this.physicsWorld = physicsWorld;
        this.is3D = is3D;
        this.gameRoot = new Group();
        this.uiRoot = new Group();
        this.entities = new ArrayList();
        this.zChangeListener = (arg_0, arg_1, arg_2) -> GameScene.zChangeListener$lambda$0(this, arg_0, arg_1, arg_2);
        this.camera3D$delegate = LazyKt.lazy(camera3D.2.INSTANCE);
        this.mouseWarper$delegate = LazyKt.lazy((Function0)new Function0<MouseWarper>(this){
            final /* synthetic */ GameScene this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final MouseWarper invoke() {
                return Async.INSTANCE.startAsyncFX(() -> mouseWarper.2.invoke$lambda$0(this.this$0)).await();
            }

            private static final MouseWarper invoke$lambda$0(GameScene this$0) {
                Intrinsics.checkNotNullParameter(this$0, "this$0");
                return this$0.new MouseWarper(this$0.getWindow());
            }
        });
        Node[] nodeArray = new Node[]{this.is3D ? (Node)this.make3DSubScene(width, height) : (Node)this.gameRoot, this.uiRoot};
        this.getContentRoot().getChildren().addAll((Node[])nodeArray);
        if (this.is3D) {
            EventHandler<MouseEvent> mouse3DHandler = arg_0 -> GameScene._init_$lambda$2(this, arg_0);
            Input input = this.getInput();
            EventType<MouseEvent> eventType = MouseEvent.MOUSE_MOVED;
            Intrinsics.checkNotNullExpressionValue(eventType, "MOUSE_MOVED");
            input.addEventHandler(eventType, mouse3DHandler);
            Input input2 = this.getInput();
            EventType<MouseEvent> eventType2 = MouseEvent.MOUSE_DRAGGED;
            Intrinsics.checkNotNullExpressionValue(eventType2, "MOUSE_DRAGGED");
            input2.addEventHandler(eventType2, mouse3DHandler);
        }
        this.initViewport(width, height);
        this.getContentRoot().getChildren().add(this.getViewport().getCamera().getViewComponent().getParent());
        log.debug("Game scene initialized: " + width + "x" + height);
        this.gameWorld.addWorldListener(this.physicsWorld);
        this.gameWorld.addWorldListener(this);
    }

    public /* synthetic */ GameScene(int n, int n2, GameWorld gameWorld, PhysicsWorld physicsWorld, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(n, n2, gameWorld, physicsWorld, bl);
    }

    @NotNull
    public final GameWorld getGameWorld() {
        return this.gameWorld;
    }

    @NotNull
    public final PhysicsWorld getPhysicsWorld() {
        return this.physicsWorld;
    }

    @JvmName(name="getUINodes")
    @NotNull
    public final ObservableList<Node> getUINodes() {
        ObservableList<Node> observableList = this.uiRoot.getChildrenUnmodifiable();
        Intrinsics.checkNotNullExpressionValue(observableList, "uiRoot.childrenUnmodifiable");
        return observableList;
    }

    public final boolean isSingleStep() {
        return this.isSingleStep;
    }

    public final void setSingleStep(boolean bl) {
        this.isSingleStep = bl;
    }

    @NotNull
    public final Camera3D getCamera3D() {
        Lazy lazy = this.camera3D$delegate;
        return (Camera3D)lazy.getValue();
    }

    private final MouseWarper getMouseWarper() {
        Lazy lazy = this.mouseWarper$delegate;
        return (MouseWarper)lazy.getValue();
    }

    public final boolean isMouseGrabbed() {
        return this.isMouseGrabbed;
    }

    public final void setMouseGrabbed(boolean bl) {
        this.isMouseGrabbed = bl;
    }

    public final boolean isFPSCamera() {
        return this.isFPSCamera;
    }

    public final void setFPSCamera(boolean value) {
        this.isFPSCamera = value;
        this.isMouseGrabbed = value;
        if (value) {
            Async.INSTANCE.startAsyncFX(() -> GameScene._set_isFPSCamera_$lambda$1(this));
        }
    }

    private final SubScene make3DSubScene(double w, double h) {
        SubScene scene3D = new SubScene(this.gameRoot, w, h, true, SceneAntialiasing.BALANCED);
        scene3D.setCamera(this.getCamera3D().getPerspectiveCamera());
        return scene3D;
    }

    private final void initViewport(double w, double h) {
        this.gameRoot.translateXProperty().bind(this.getViewport().xProperty().negate());
        this.gameRoot.translateYProperty().bind(this.getViewport().yProperty().negate());
        Scale scale = new Scale();
        scale.pivotXProperty().bind(this.getViewport().xProperty());
        scale.pivotYProperty().bind(this.getViewport().yProperty());
        scale.xProperty().bind(this.getViewport().zoomProperty());
        scale.yProperty().bind(this.getViewport().zoomProperty());
        this.gameRoot.getTransforms().add(scale);
        Rotate rotate = new Rotate(0.0, Rotate.Z_AXIS);
        rotate.pivotXProperty().bind(this.getViewport().xProperty().add(w / (double)2));
        rotate.pivotYProperty().bind(this.getViewport().yProperty().add(h / (double)2));
        rotate.angleProperty().bind(this.getViewport().angleProperty().negate());
        this.gameRoot.getTransforms().add(rotate);
    }

    @Override
    protected void onUpdate(double tpf) {
        if (this.isSingleStep) {
            return;
        }
        this.step(tpf);
    }

    public final void step(double tpf) {
        this.gameWorld.onUpdate(tpf);
        this.physicsWorld.onUpdate(tpf);
        this.getViewport().onUpdate(tpf);
        if (!this.is3D && this.isZSortingNeeded) {
            this.sortZ();
            this.isZSortingNeeded = false;
        }
        if (this.is3D) {
            this.getCamera3D().update(tpf);
        }
        if (this.isMouseGrabbed && this.getWindow().isFocused()) {
            if (this.getInput().getMouseXUI() < 10.0) {
                this.getMouseWarper().warpToCenter();
            } else if (this.getInput().getMouseXUI() + (double)10 > (double)FXGL.Companion.getAppWidth()) {
                this.getMouseWarper().warpToCenter();
            } else if (this.getInput().getMouseYUI() < 10.0) {
                this.getMouseWarper().warpToCenter();
            } else if (this.getInput().getMouseYUI() + (double)10 > (double)FXGL.Companion.getAppHeight()) {
                this.getMouseWarper().warpToCenter();
            }
        }
    }

    public final void addUINode(@NotNull Node node) {
        Intrinsics.checkNotNullParameter(node, "node");
        this.uiRoot.getChildren().add(node);
    }

    public final void addUINodes(Node ... nodes) {
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        for (Node node : nodes) {
            this.addUINode(node);
        }
    }

    public final boolean removeUINode(@NotNull Node n) {
        Intrinsics.checkNotNullParameter(n, "n");
        return this.uiRoot.getChildren().remove(n);
    }

    public final void removeUINodes(Node ... nodes) {
        Intrinsics.checkNotNullParameter(nodes, "nodes");
        for (Node node : nodes) {
            this.removeUINode(node);
        }
    }

    public final void addUI(@NotNull UI ui) {
        Intrinsics.checkNotNullParameter(ui, "ui");
        this.addUINode(ui.getRoot());
    }

    public final void removeUI(@NotNull UI ui) {
        Intrinsics.checkNotNullParameter(ui, "ui");
        this.removeUINode(ui.getRoot());
    }

    public final void clearGameViews() {
        this.gameRoot.getChildren().clear();
    }

    public final void clearUINodes() {
        this.uiRoot.getChildren().clear();
    }

    public final void setUIMouseTransparent(boolean b) {
        this.uiRoot.setMouseTransparent(b);
    }

    private final void sortZ() {
        ArrayList tmp = new ArrayList(this.gameRoot.getChildren());
        List $this$sortBy$iv = tmp;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, new Comparator(){

                public final int compare(T a, T b) {
                    Node it = (Node)a;
                    boolean bl = false;
                    V v = it.getProperties().get("viewData");
                    Intrinsics.checkNotNull(v, "null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    it = (Node)b;
                    Comparable comparable = Integer.valueOf(((GameView)v).getZ());
                    bl = false;
                    V v2 = it.getProperties().get("viewData");
                    Intrinsics.checkNotNull(v2, "null cannot be cast to non-null type com.almasb.fxgl.app.scene.GameView");
                    return ComparisonsKt.compareValues(comparable, ((GameView)v2).getZ());
                }
            });
        }
        this.gameRoot.getChildren().setAll(tmp);
    }

    public final void reset$fxgl() {
        log.debug("Clearing game scene");
        this.gameWorld.reset();
        this.gameWorld.addWorldListener(this.physicsWorld);
        this.gameWorld.addWorldListener(this);
        this.physicsWorld.clear();
        this.physicsWorld.clearCollisionHandlers();
        this.getTimer().clear();
        this.getViewport().unbind();
        this.gameRoot.getChildren().clear();
        this.uiRoot.getChildren().clear();
    }

    @Override
    public void onEntityAdded(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.entities.add(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue(viewComponent, "entity.viewComponent");
        this.initView(viewComponent);
    }

    @Override
    public void onEntityRemoved(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        this.entities.remove(entity);
        ViewComponent viewComponent = entity.getViewComponent();
        Intrinsics.checkNotNullExpressionValue(viewComponent, "entity.viewComponent");
        this.destroyView(viewComponent);
    }

    public final void addGameView(@NotNull GameView view2) {
        Intrinsics.checkNotNullParameter(view2, "view");
        view2.getZProperty().addListener((ChangeListener<? super Number>)this.zChangeListener);
        ObservableMap<Object, Object> observableMap = view2.getNode().getProperties();
        Intrinsics.checkNotNullExpressionValue(observableMap, "view.node.properties");
        Map map = observableMap;
        map.put("viewData", view2);
        this.gameRoot.getChildren().add(view2.getNode());
        this.isZSortingNeeded = true;
    }

    public final void removeGameView(@NotNull GameView view2) {
        Intrinsics.checkNotNullParameter(view2, "view");
        view2.getNode().getProperties().clear();
        this.gameRoot.getChildren().remove(view2.getNode());
    }

    private final void initView(ViewComponent viewComponent) {
        Node node = viewComponent.getParent();
        Integer n = viewComponent.zIndexProperty().getValue();
        Intrinsics.checkNotNullExpressionValue(n, "viewComponent.zIndexProperty.value");
        GameView view2 = new GameView(node, ((Number)n).intValue());
        view2.getZProperty().bind(viewComponent.zIndexProperty());
        this.addGameView(view2);
    }

    private final void destroyView(ViewComponent viewComponent) {
        block0: {
            Object v = viewComponent.getParent().getProperties().get("viewData");
            if (v == null) break block0;
            Object it = v;
            boolean bl = false;
            GameView view2 = (GameView)it;
            view2.getZProperty().unbind();
            view2.getZProperty().removeListener((ChangeListener<? super Number>)this.zChangeListener);
            this.removeGameView(view2);
        }
    }

    @Override
    public void onEnteredFrom(@NotNull Scene prevState) {
        Intrinsics.checkNotNullParameter(prevState, "prevState");
        if (this.isCursorInvisibleNeeded) {
            this.setCursorInvisible();
        }
    }

    @Override
    public void onExitingTo(@NotNull Scene nextState) {
        block2: {
            Cursor newCursor;
            Intrinsics.checkNotNullParameter(nextState, "nextState");
            this.isCursorInvisibleNeeded = this.isCursorInvisible();
            if (!this.isCursorInvisibleNeeded) break block2;
            Cursor cursor = this.getPreInvisibleCursor();
            if (cursor == null) {
                cursor = this.getWindow().getDefaultCursor();
            }
            Cursor cursor2 = newCursor = cursor;
            if (cursor2 != null) {
                Cursor it = cursor2;
                boolean bl = false;
                this.setCursor(it);
            }
        }
    }

    @JvmOverloads
    public GameScene(int width, int height, @NotNull GameWorld gameWorld, @NotNull PhysicsWorld physicsWorld) {
        Intrinsics.checkNotNullParameter(gameWorld, "gameWorld");
        Intrinsics.checkNotNullParameter(physicsWorld, "physicsWorld");
        this(width, height, gameWorld, physicsWorld, false, 16, null);
    }

    private static final void zChangeListener$lambda$0(GameScene this$0, ObservableValue observableValue, Number number, Number number2) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.isZSortingNeeded = true;
    }

    private static final void _set_isFPSCamera_$lambda$1(GameScene this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.getMouseWarper().warpToCenter();
    }

    private static final void _init_$lambda$2(GameScene this$0, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        if (this$0.isMouseGrabbed && (int)it.getScreenX() == (int)this$0.getMouseWarper().getWarpScreenX() && (int)it.getScreenY() == (int)this$0.getMouseWarper().getWarpScreenY()) {
            this$0.lastMouseX = it.getScreenX() - this$0.getWindow().getX();
            this$0.lastMouseY = it.getScreenY() - this$0.getWindow().getY();
            return;
        }
        if (!this$0.isFPSCamera) {
            return;
        }
        double mouseX = it.getScreenX() - this$0.getWindow().getX();
        double mouseY = it.getScreenY() - this$0.getWindow().getY();
        double offsetX = mouseX - this$0.lastMouseX;
        double offsetY = mouseY - this$0.lastMouseY;
        if (FXGLMath.abs(offsetX) < 100.0 && FXGLMath.abs(offsetY) < 100.0) {
            double mouseSensitivity = FXGL.Companion.getSettings().getMouseSensitivity();
            if (FXGLMath.abs(offsetX) > 0.5) {
                if (mouseX > this$0.lastMouseX) {
                    this$0.getCamera3D().getTransform().lookRightBy(mouseSensitivity * (mouseX - this$0.lastMouseX));
                } else if (mouseX < this$0.lastMouseX) {
                    this$0.getCamera3D().getTransform().lookLeftBy(mouseSensitivity * (this$0.lastMouseX - mouseX));
                }
            }
            if (FXGLMath.abs(offsetY) > 0.5) {
                if (mouseY > this$0.lastMouseY) {
                    double angle = mouseSensitivity * (mouseY - this$0.lastMouseY);
                    if (this$0.getCamera3D().isOverRotationXAllowed() || this$0.getCamera3D().getTransform().getRotationX() - angle > -85.0) {
                        this$0.getCamera3D().getTransform().lookDownBy(angle);
                    }
                } else if (mouseY < this$0.lastMouseY) {
                    double angle = mouseSensitivity * (this$0.lastMouseY - mouseY);
                    if (this$0.getCamera3D().isOverRotationXAllowed() || this$0.getCamera3D().getTransform().getRotationX() + angle < 85.0) {
                        this$0.getCamera3D().getTransform().lookUpBy(angle);
                    }
                }
            }
        }
        this$0.lastMouseX = mouseX;
        this$0.lastMouseY = mouseY;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene$Companion;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "fxgl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0012\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0014"}, d2={"Lcom/almasb/fxgl/app/scene/GameScene$MouseWarper;", "", "window", "Lcom/almasb/fxgl/app/MainWindow;", "(Lcom/almasb/fxgl/app/scene/GameScene;Lcom/almasb/fxgl/app/MainWindow;)V", "robot", "Ljavafx/scene/robot/Robot;", "warpScreenX", "", "getWarpScreenX", "()D", "setWarpScreenX", "(D)V", "warpScreenY", "getWarpScreenY", "setWarpScreenY", "getWindow", "()Lcom/almasb/fxgl/app/MainWindow;", "warpToCenter", "", "fxgl"})
    private final class MouseWarper {
        @NotNull
        private final MainWindow window;
        @NotNull
        private final Robot robot;
        private double warpScreenX;
        private double warpScreenY;

        public MouseWarper(MainWindow window2) {
            Intrinsics.checkNotNullParameter(window2, "window");
            this.window = window2;
            this.robot = new Robot();
        }

        @NotNull
        public final MainWindow getWindow() {
            return this.window;
        }

        public final double getWarpScreenX() {
            return this.warpScreenX;
        }

        public final void setWarpScreenX(double d) {
            this.warpScreenX = d;
        }

        public final double getWarpScreenY() {
            return this.warpScreenY;
        }

        public final void setWarpScreenY(double d) {
            this.warpScreenY = d;
        }

        public final void warpToCenter() {
            this.warpScreenX = this.window.getX() + this.window.getWidth() / 2.0;
            this.warpScreenY = this.window.getY() + this.window.getHeight() / 2.0;
            this.robot.mouseMove(this.warpScreenX, this.warpScreenY);
        }
    }
}

