/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app.scene;

import com.almasb.fxgl.logging.LoggerKt;
import com.almasb.fxgl.scene.SubScene;
import com.almasb.fxgl.ui.MDIWindow;
import java.util.Collection;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/almasb/fxgl/app/scene/ErrorSubScene;", "Lcom/almasb/fxgl/scene/SubScene;", "sceneWidth", "", "sceneHeight", "error", "", "action", "Ljava/lang/Runnable;", "(DDLjava/lang/Throwable;Ljava/lang/Runnable;)V", "getAction", "()Ljava/lang/Runnable;", "getError", "()Ljava/lang/Throwable;", "getSceneHeight", "()D", "getSceneWidth", "makeErrorMessage", "", "makeStackTrace", "makeStackTraceArea", "Ljavafx/scene/control/TextArea;", "fxgl"})
@SourceDebugExtension(value={"SMAP\nErrorSubScene.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ErrorSubScene.kt\ncom/almasb/fxgl/app/scene/ErrorSubScene\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,78:1\n1099#2,3:79\n*S KotlinDebug\n*F\n+ 1 ErrorSubScene.kt\ncom/almasb/fxgl/app/scene/ErrorSubScene\n*L\n55#1:79,3\n*E\n"})
public final class ErrorSubScene
extends SubScene {
    private final double sceneWidth;
    private final double sceneHeight;
    @NotNull
    private final Throwable error;
    @NotNull
    private final Runnable action;

    public ErrorSubScene(double sceneWidth, double sceneHeight, @NotNull Throwable error, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter(error, "error");
        Intrinsics.checkNotNullParameter(action, "action");
        this.sceneWidth = sceneWidth;
        this.sceneHeight = sceneHeight;
        this.error = error;
        this.action = action;
        Button btnOK = new Button("Exit game");
        btnOK.setOnAction(arg_0 -> ErrorSubScene._init_$lambda$0(this, arg_0));
        ScrollPane scrollPane = new ScrollPane(this.makeStackTraceArea());
        scrollPane.setPrefSize(this.sceneWidth, this.sceneHeight);
        MDIWindow window2 = new MDIWindow(null, 1, null);
        window2.setCloseable(false);
        window2.setTitle("Error Reporter");
        ObservableList<Node> observableList = window2.getContentPane().getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList, "window.contentPane.children");
        Collection collection = observableList;
        Node[] nodeArray = new Node[]{btnOK, scrollPane};
        collection.add(new VBox(nodeArray));
        ObservableList<Node> observableList2 = this.getContentRoot().getChildren();
        Intrinsics.checkNotNullExpressionValue(observableList2, "contentRoot.children");
        ((Collection)observableList2).add(window2);
    }

    public final double getSceneWidth() {
        return this.sceneWidth;
    }

    public final double getSceneHeight() {
        return this.sceneHeight;
    }

    @NotNull
    public final Throwable getError() {
        return this.error;
    }

    @NotNull
    public final Runnable getAction() {
        return this.action;
    }

    /*
     * WARNING - void declaration
     */
    private final TextArea makeStackTraceArea() {
        void $this$count$iv;
        TextArea textArea;
        TextArea $this$makeStackTraceArea_u24lambda_u242 = textArea = new TextArea(this.makeErrorMessage() + "\n\n" + this.makeStackTrace());
        boolean bl = false;
        $this$makeStackTraceArea_u24lambda_u242.setEditable(false);
        $this$makeStackTraceArea_u24lambda_u242.setWrapText(true);
        String string = $this$makeStackTraceArea_u24lambda_u242.getText();
        Intrinsics.checkNotNullExpressionValue(string, "text");
        CharSequence charSequence = string;
        double d = this.sceneWidth;
        TextArea textArea2 = $this$makeStackTraceArea_u24lambda_u242;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int j = 0; j < $this$count$iv.length(); ++j) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(j);
            boolean bl2 = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n = count$iv;
        textArea2.setPrefSize(d, (double)(n + 1) * 20.0);
        return textArea;
    }

    private final String makeErrorMessage() {
        Object name = null;
        String line = null;
        StackTraceElement[] stackTraceElementArray = this.error.getStackTrace();
        Intrinsics.checkNotNullExpressionValue(stackTraceElementArray, "error.stackTrace");
        if (((Object[])stackTraceElementArray).length == 0) {
            name = "Empty stack trace";
            line = "Empty stack trace";
        } else {
            StackTraceElement[] stackTraceElementArray2 = this.error.getStackTrace();
            Intrinsics.checkNotNullExpressionValue(stackTraceElementArray2, "error.stackTrace");
            StackTraceElement trace = (StackTraceElement)ArraysKt.first((Object[])stackTraceElementArray2);
            String string = trace.getClassName();
            Intrinsics.checkNotNullExpressionValue(string, "trace.className");
            name = StringsKt.substringAfterLast$default(string, '.', null, 2, null) + "." + trace.getMethodName() + "()";
            String string2 = trace.toString();
            Intrinsics.checkNotNullExpressionValue(string2, "trace.toString()");
            line = StringsKt.substringBefore$default(StringsKt.substringAfter$default(string2, '(', null, 2, null), ')', null, 2, null);
        }
        return "Message:  " + this.error.getMessage() + "\nType:  " + this.error.getClass().getSimpleName() + "\nMethod:  " + (String)name + "\nLine:  " + line;
    }

    private final String makeStackTrace() {
        return LoggerKt.stackTraceToString(this.error);
    }

    private static final void _init_$lambda$0(ErrorSubScene this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.action.run();
    }
}

