/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ApplicationMode;
import com.almasb.fxgl.app.SystemActions;
import com.almasb.fxgl.dev.DebugCameraScene;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.dsl.FXGLForKtKt;
import com.almasb.fxgl.entity.Entity;
import com.almasb.fxgl.entity.component.Component;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.InputModifier;
import com.almasb.fxgl.input.UserAction;
import com.almasb.fxgl.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.KeyCode;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003*\u0006\n\r\u0014\u0017\u001a\u001d\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\r\u0010\t\u001a\u00020\nH\u0002\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\r\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\r\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/almasb/fxgl/app/SystemActions;", "", "()V", "log", "Lcom/almasb/fxgl/logging/Logger;", "bind", "", "input", "Lcom/almasb/fxgl/input/Input;", "devConsole", "com/almasb/fxgl/app/SystemActions$devConsole$1", "()Lcom/almasb/fxgl/app/SystemActions$devConsole$1;", "devOptions", "com/almasb/fxgl/app/SystemActions$devOptions$1", "()Lcom/almasb/fxgl/app/SystemActions$devOptions$1;", "getChildrenSize", "", "node", "Ljavafx/scene/Node;", "restartGame", "com/almasb/fxgl/app/SystemActions$restartGame$1", "()Lcom/almasb/fxgl/app/SystemActions$restartGame$1;", "screenshot", "com/almasb/fxgl/app/SystemActions$screenshot$1", "()Lcom/almasb/fxgl/app/SystemActions$screenshot$1;", "sysdump", "com/almasb/fxgl/app/SystemActions$sysdump$1", "()Lcom/almasb/fxgl/app/SystemActions$sysdump$1;", "toggleDebugCamera", "com/almasb/fxgl/app/SystemActions$toggleDebugCamera$1", "()Lcom/almasb/fxgl/app/SystemActions$toggleDebugCamera$1;", "fxgl"})
@SourceDebugExtension(value={"SMAP\nSystemActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SystemActions.kt\ncom/almasb/fxgl/app/SystemActions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n1549#2:124\n1620#2,3:125\n*S KotlinDebug\n*F\n+ 1 SystemActions.kt\ncom/almasb/fxgl/app/SystemActions\n*L\n119#1:124\n119#1:125,3\n*E\n"})
public final class SystemActions {
    @NotNull
    public static final SystemActions INSTANCE = new SystemActions();
    @NotNull
    private static final Logger log = Logger.Companion.get(INSTANCE.getClass());

    private SystemActions() {
    }

    public final void bind(@NotNull Input input) {
        Intrinsics.checkNotNullParameter(input, "input");
        input.addAction((UserAction)this.screenshot(), KeyCode.DIGIT8, InputModifier.CTRL);
        if (FXGL.Companion.getSettings().getApplicationMode() != ApplicationMode.RELEASE) {
            if (FXGL.Companion.getSettings().isDeveloperMenuEnabled()) {
                Input.addAction$default(input, (UserAction)this.devOptions(), KeyCode.DIGIT1, null, 4, null);
                Input.addAction$default(input, (UserAction)this.devConsole(), KeyCode.DIGIT2, null, 4, null);
            }
            input.addAction((UserAction)this.sysdump(), KeyCode.DIGIT9, InputModifier.CTRL);
            input.addAction((UserAction)this.restartGame(), KeyCode.R, InputModifier.CTRL);
            input.addAction((UserAction)this.toggleDebugCamera(), KeyCode.DIGIT7, InputModifier.CTRL);
        }
    }

    private final screenshot.1 screenshot() {
        return new UserAction(){

            protected void onActionBegin() {
                FXGL.Companion.getWindowService().saveScreenshot();
            }
        };
    }

    private final devConsole.1 devConsole() {
        return new UserAction(){

            protected void onActionBegin() {
                if (FXGL.Companion.getSettings().getApplicationMode() == ApplicationMode.RELEASE) {
                    return;
                }
                FXGL.Companion.getDevService().openConsole();
            }
        };
    }

    private final devOptions.1 devOptions() {
        return new UserAction(){

            protected void onActionBegin() {
                if (FXGLForKtKt.isReleaseMode()) {
                    return;
                }
                if (FXGL.Companion.getDevService().isDevPaneOpen()) {
                    FXGL.Companion.getDevService().closeDevPane();
                } else {
                    FXGL.Companion.getDevService().openDevPane();
                }
            }
        };
    }

    private final sysdump.1 sysdump() {
        return new UserAction(){

            /*
             * WARNING - void declaration
             */
            protected void onActionBegin() {
                void $this$flatMapTo$iv$iv;
                void $this$flatMap$iv;
                SystemActions.access$getLog$p().info("--- System info dump begin ---");
                Object[] objectArray = new Object[]{FXGLForKtKt.getGameWorld().getEntities().size()};
                SystemActions.access$getLog$p().infof("Entities size: %d", objectArray);
                objectArray = new Object[1];
                Iterable iterable = FXGLForKtKt.getGameWorld().getEntities();
                int n = 0;
                Object[] objectArray2 = objectArray;
                String string = "Components size: %d";
                Logger logger = SystemActions.access$getLog$p();
                boolean $i$f$flatMap = false;
                void var4_8 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    Entity it = (Entity)element$iv$iv;
                    boolean bl = false;
                    List<Component> list = it.getComponents();
                    Intrinsics.checkNotNullExpressionValue(list, "it.components");
                    Iterable list$iv$iv = list;
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                List list = (List)destination$iv$iv;
                objectArray2[n] = list.size();
                logger.infof(string, objectArray);
                SystemActions.access$getLog$p().info("--- System info dump end ---");
            }
        };
    }

    private final restartGame.1 restartGame() {
        return new UserAction(){

            protected void onActionBegin() {
                FXGL.Companion.getGameController().startNewGame();
            }
        };
    }

    private final toggleDebugCamera.1 toggleDebugCamera() {
        return new UserAction(){
            @NotNull
            private final Lazy debugCameraScene$delegate;
            {
                this.debugCameraScene$delegate = LazyKt.lazy(toggleDebugCamera.debugCameraScene.2.INSTANCE);
            }

            private final DebugCameraScene getDebugCameraScene() {
                Lazy lazy = this.debugCameraScene$delegate;
                return (DebugCameraScene)lazy.getValue();
            }

            protected void onActionBegin() {
                FXGLForKtKt.getSettings().devEnableDebugCameraProperty().setValue(FXGLForKtKt.getSettings().devEnableDebugCameraProperty().getValue() == false);
                Boolean bl = FXGLForKtKt.getSettings().devEnableDebugCameraProperty().getValue();
                Intrinsics.checkNotNullExpressionValue(bl, "getSettings().devEnableDebugCamera.value");
                if (bl.booleanValue()) {
                    FXGL.Companion.getSceneService().pushSubScene(this.getDebugCameraScene());
                } else {
                    FXGL.Companion.getSceneService().popSubScene();
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final int getChildrenSize(Node node) {
        int n;
        log.debug("Counting children for " + node);
        if (node instanceof Parent) {
            Collection<Integer> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            int n2 = ((Parent)node).getChildrenUnmodifiable().size();
            ObservableList<Node> observableList = ((Parent)node).getChildrenUnmodifiable();
            Intrinsics.checkNotNullExpressionValue(observableList, "node.childrenUnmodifiable");
            Iterable iterable = observableList;
            int n3 = n2;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Node node2 = (Node)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue(it, "it");
                collection.add(INSTANCE.getChildrenSize((Node)it));
            }
            collection = (List)destination$iv$iv;
            n = n3 + CollectionsKt.sumOfInt((Iterable<Integer>)collection);
        } else {
            n = 0;
        }
        return n;
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }
}

