/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.MainWindow;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.app.scene.Viewport;
import com.almasb.fxgl.input.MouseEventData;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ!\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u00020 0\u001f\"\u00020 H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u001dH\u0016J\u0010\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u001dH\u0002J\b\u0010)\u001a\u00020\u001dH\u0002J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020+H\u0014J\b\u0010,\u001a\u00020\u001dH\u0016J\b\u0010-\u001a\u00020.H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000eR\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000eR\u0014\u0010\u001a\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006/"}, d2={"Lcom/almasb/fxgl/app/PrimaryStageWindow;", "Lcom/almasb/fxgl/app/MainWindow;", "stage", "Ljavafx/stage/Stage;", "scene", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "(Ljavafx/stage/Stage;Lcom/almasb/fxgl/app/scene/FXGLScene;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "fxScene", "Ljavafx/scene/Scene;", "height", "", "getHeight", "()D", "isFocused", "", "()Z", "getStage", "()Ljavafx/stage/Stage;", "width", "getWidth", "windowBorderHeight", "windowBorderWidth", "x", "getX", "y", "getY", "addCSS", "", "cssList", "", "Lcom/almasb/fxgl/scene/CSS;", "([Lcom/almasb/fxgl/scene/CSS;)V", "close", "createFXScene", "root", "Ljavafx/scene/Parent;", "iconifiedProperty", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "initStage", "onStageResize", "setRoot", "Ljavafx/scene/layout/Pane;", "show", "takeScreenshot", "Ljavafx/scene/image/Image;", "fxgl"})
@SourceDebugExtension(value={"SMAP\nMainWindow.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MainWindow.kt\ncom/almasb/fxgl/app/PrimaryStageWindow\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,762:1\n11335#2:763\n11670#2,3:764\n800#3,11:767\n1855#3,2:778\n*S KotlinDebug\n*F\n+ 1 MainWindow.kt\ncom/almasb/fxgl/app/PrimaryStageWindow\n*L\n482#1:763\n482#1:764,3\n503#1:767,11\n504#1:778,2\n*E\n"})
public final class PrimaryStageWindow
extends MainWindow {
    @NotNull
    private final Stage stage;
    @NotNull
    private final javafx.scene.Scene fxScene;
    private double windowBorderWidth;
    private double windowBorderHeight;

    public PrimaryStageWindow(@NotNull Stage stage, @NotNull FXGLScene scene2, @NotNull ReadOnlyGameSettings settings) {
        Intrinsics.checkNotNullParameter(stage, "stage");
        Intrinsics.checkNotNullParameter(scene2, "scene");
        Intrinsics.checkNotNullParameter(settings, "settings");
        super(scene2, settings, null);
        this.stage = stage;
        this.fxScene = this.createFXScene(scene2.getRoot());
        this.setInitialScene(scene2);
        this.initStage();
        this.addKeyHandler(this.fxScene, (Function1<? super KeyEvent, Unit>)new Function1<KeyEvent, Unit>(){

            @Override
            public final void invoke(final @NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter(e, "e");
                this.getInput$fxgl().onKeyEvent(e);
                this.getStateMachine().runOnActiveStates(new Function1<Scene, Unit>(){

                    @Override
                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        it.getInput().onKeyEvent(e);
                    }
                });
            }
        });
        this.addMouseHandler(this.fxScene, (Function1<? super MouseEventData, Unit>)new Function1<MouseEventData, Unit>(){

            @Override
            public final void invoke(final @NotNull MouseEventData e) {
                Intrinsics.checkNotNullParameter(e, "e");
                this.getInput$fxgl().onMouseEvent(e);
                this.getStateMachine().runOnActiveStates(new Function1<Scene, Unit>(){

                    @Override
                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        it.getInput().onMouseEvent(e);
                    }
                });
            }
        });
        this.addGlobalHandler(this.fxScene, (Function1<? super Event, Unit>)new Function1<Event, Unit>(){

            @Override
            public final void invoke(final @NotNull Event e) {
                Intrinsics.checkNotNullParameter(e, "e");
                this.getInput$fxgl().fireEventViaFilters(e);
                this.getStateMachine().runOnActiveStates(new Function1<Scene, Unit>(){

                    @Override
                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        it.getInput().fireEventViaFilters(e);
                    }
                });
            }
        }, (Function1<? super Event, Unit>)new Function1<Event, Unit>(){

            @Override
            public final void invoke(final @NotNull Event e) {
                Intrinsics.checkNotNullParameter(e, "e");
                this.getInput$fxgl().fireEventViaHandlers(e);
                this.getStateMachine().runOnActiveStates(new Function1<Scene, Unit>(){

                    @Override
                    public final void invoke(@NotNull Scene it) {
                        Intrinsics.checkNotNullParameter(it, "it");
                        it.getInput().fireEventViaHandlers(e);
                    }
                });
            }
        });
    }

    @Override
    @NotNull
    public Stage getStage() {
        return this.stage;
    }

    @Override
    public double getX() {
        return this.getStage().getX();
    }

    @Override
    public double getY() {
        return this.getStage().getY();
    }

    @Override
    public double getWidth() {
        return this.getStage().getWidth();
    }

    @Override
    public double getHeight() {
        return this.getStage().getHeight();
    }

    @Override
    public boolean isFocused() {
        return this.getStage().isFocused();
    }

    private final javafx.scene.Scene createFXScene(Parent root) {
        Rectangle2D bounds;
        this.getLog().debug("Creating a JavaFX scene");
        double newW = this.getSettings().getWidth();
        double newH = this.getSettings().getHeight();
        Rectangle2D rectangle2D = bounds = this.getSettings().isFullScreenAllowed() ? Screen.getPrimary().getBounds() : Screen.getPrimary().getVisualBounds();
        if (newW > bounds.getWidth() || newH > bounds.getHeight()) {
            this.getLog().debug("Target size > screen size");
            double extraMargin = 25.0;
            double ratio = newW / newH;
            for (int newWidth = (int)bounds.getWidth(); 0 < newWidth; --newWidth) {
                if (!((double)newWidth / ratio <= bounds.getHeight())) continue;
                newW = (double)newWidth - extraMargin;
                newH = (double)newWidth / ratio;
                break;
            }
        }
        newW = (int)newW;
        newH = (int)newH;
        javafx.scene.Scene scene2 = new javafx.scene.Scene(root, newW, newH);
        this.getScaledWidth().set(newW);
        this.getScaledHeight().set(newH);
        this.getScaleRatioX().set(this.getScaledWidth().getValue() / (double)this.getSettings().getWidth());
        this.getScaleRatioY().set(this.getScaledHeight().getValue() / (double)this.getSettings().getHeight());
        this.getLog().debug("Target settings size: " + (double)this.getSettings().getWidth() + " x " + (double)this.getSettings().getHeight());
        this.getLog().debug("Scaled scene size:    " + newW + " x " + newH);
        this.getLog().debug("Scaled ratio: (" + this.getScaleRatioX().getValue() + ", " + this.getScaleRatioY().getValue() + ")");
        return scene2;
    }

    private final void initStage() {
        Stage $this$initStage_u24lambda_u242 = this.getStage();
        boolean bl = false;
        $this$initStage_u24lambda_u242.setScene(this.fxScene);
        $this$initStage_u24lambda_u242.setTitle(this.getSettings().getTitle() + " " + this.getSettings().getVersion());
        $this$initStage_u24lambda_u242.setResizable(this.getSettings().isManualResizeEnabled());
        if (this.getSettings().isDesktop()) {
            $this$initStage_u24lambda_u242.initStyle(this.getSettings().getStageStyle());
        }
        $this$initStage_u24lambda_u242.setOnCloseRequest(arg_0 -> PrimaryStageWindow.initStage$lambda$2$lambda$0(this, arg_0));
        if (this.getSettings().isFullScreenAllowed()) {
            $this$initStage_u24lambda_u242.setFullScreenExitHint("");
            $this$initStage_u24lambda_u242.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            this.getSettings().getFullScreen().addListener((ChangeListener<? super Boolean>)((ChangeListener<Object>)(arg_0, arg_1, arg_2) -> PrimaryStageWindow.initStage$lambda$2$lambda$1(new Function3<ObservableValue<? extends Boolean>, Boolean, Boolean, Unit>($this$initStage_u24lambda_u242){
                final /* synthetic */ Stage $this_with;
                {
                    this.$this_with = $receiver;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean fullscreenNow) {
                    Intrinsics.checkNotNullExpressionValue(fullscreenNow, "fullscreenNow");
                    this.$this_with.setFullScreen(fullscreenNow);
                }
            }, arg_0, arg_1, arg_2)));
        }
        $this$initStage_u24lambda_u242.sizeToScene();
        $this$initStage_u24lambda_u242.centerOnScreen();
    }

    @Override
    public void show() {
        this.getLog().debug("Opening main window");
        this.getStage().show();
        double d = this.getStage().getWidth();
        Double d2 = this.getScaledWidth().getValue();
        Intrinsics.checkNotNullExpressionValue(d2, "scaledWidth.value");
        this.windowBorderWidth = d - ((Number)d2).doubleValue();
        double d3 = this.getStage().getHeight();
        Double d4 = this.getScaledHeight().getValue();
        Intrinsics.checkNotNullExpressionValue(d4, "scaledHeight.value");
        this.windowBorderHeight = d3 - ((Number)d4).doubleValue();
        if (this.windowBorderHeight < 0.5 && this.getSettings().isLinux()) {
            this.windowBorderHeight = 35.0;
        }
        this.getScaledWidth().bind(this.getStage().widthProperty().subtract(Bindings.when(this.getStage().fullScreenProperty()).then(0).otherwise(this.windowBorderWidth)));
        this.getScaledHeight().bind(this.getStage().heightProperty().subtract(Bindings.when(this.getStage().fullScreenProperty()).then(0).otherwise(this.windowBorderHeight)));
        this.getSettings().getScaledWidthProp$fxgl().bind(this.getScaledWidth());
        this.getSettings().getScaledHeightProp$fxgl().bind(this.getScaledHeight());
        if (this.getSettings().isScaleAffectedOnResize()) {
            if (this.getSettings().isPreserveResizeRatio()) {
                this.getScaleRatioX().bind(Bindings.min((ObservableNumberValue)this.getScaledWidth().divide(this.getSettings().getWidth()), (ObservableNumberValue)this.getScaledHeight().divide(this.getSettings().getHeight())));
                this.getScaleRatioY().bind(this.getScaleRatioX());
            } else {
                this.getScaleRatioX().bind(this.getScaledWidth().divide(this.getSettings().getWidth()));
                this.getScaleRatioY().bind(this.getScaledHeight().divide(this.getSettings().getHeight()));
            }
        } else {
            this.getScaleRatioX().setValue(1.0);
            this.getScaleRatioY().setValue(1.0);
            this.getScaledWidth().addListener((arg_0, arg_1, arg_2) -> PrimaryStageWindow.show$lambda$3(new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(this){
                final /* synthetic */ PrimaryStageWindow this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number newWidth) {
                    PrimaryStageWindow.access$onStageResize(this.this$0);
                }
            }, arg_0, arg_1, arg_2));
            this.getScaledHeight().addListener((arg_0, arg_1, arg_2) -> PrimaryStageWindow.show$lambda$4(new Function3<ObservableValue<? extends Number>, Number, Number, Unit>(this){
                final /* synthetic */ PrimaryStageWindow this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(ObservableValue<? extends Number> observableValue, Number number, Number newHeight) {
                    PrimaryStageWindow.access$onStageResize(this.this$0);
                }
            }, arg_0, arg_1, arg_2));
        }
        this.getLog().debug("Window border size: (" + this.windowBorderWidth + ", " + this.windowBorderHeight + ")");
        this.getLog().debug("Scaled size: " + this.getScaledWidth().getValue() + " x " + this.getScaledHeight().getValue());
        this.getLog().debug("Scaled ratio: (" + this.getScaleRatioX().getValue() + ", " + this.getScaleRatioY().getValue() + ")");
        this.getLog().debug("Scene size: " + this.getStage().getScene().getWidth() + " x " + this.getStage().getScene().getHeight());
        this.getLog().debug("Stage size: " + this.getStage().getWidth() + " x " + this.getStage().getHeight());
        if (this.getSettings().isFullScreenAllowed() && this.getSettings().isFullScreenFromStart()) {
            this.getStage().setFullScreen(true);
            this.getLog().debug("Going fullscreen");
        }
    }

    @Override
    public void close() {
        this.getLog().debug("Closing main window");
        this.getStage().close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addCSS(CSS ... cssList) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(cssList, "cssList");
        ObservableList<String> observableList = this.fxScene.getStylesheets();
        Intrinsics.checkNotNullExpressionValue(observableList, "fxScene.stylesheets");
        Collection collection = observableList;
        CSS[] $this$map$iv = cssList;
        boolean $i$f$map = false;
        CSS[] cSSArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[j];
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getExternalForm());
        }
        Iterable iterable = (List)destination$iv$iv;
        CollectionsKt.addAll(collection, iterable);
    }

    @Override
    protected void setRoot(@NotNull Pane root) {
        Intrinsics.checkNotNullParameter(root, "root");
        this.fxScene.setRoot(root);
    }

    @Override
    @NotNull
    public ReadOnlyBooleanProperty iconifiedProperty() {
        ReadOnlyBooleanProperty readOnlyBooleanProperty = this.getStage().iconifiedProperty();
        Intrinsics.checkNotNullExpressionValue(readOnlyBooleanProperty, "stage.iconifiedProperty()");
        return readOnlyBooleanProperty;
    }

    @Override
    @NotNull
    public Image takeScreenshot() {
        WritableImage writableImage = this.fxScene.snapshot(null);
        Intrinsics.checkNotNullExpressionValue(writableImage, "fxScene.snapshot(null)");
        return writableImage;
    }

    /*
     * WARNING - void declaration
     */
    private final void onStageResize() {
        void $this$filterIsInstanceTo$iv$iv;
        Double newW = this.getScaledWidth().getValue();
        Double newH = this.getScaledHeight().getValue();
        this.getLog().debug("On Stage resize: " + newW + "x" + newH);
        Iterable $this$filterIsInstance$iv = this.getScenes();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FXGLScene)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FXGLScene it = (FXGLScene)element$iv;
            boolean bl = false;
            Viewport viewport = it.getViewport();
            Intrinsics.checkNotNullExpressionValue(newW, "newW");
            viewport.setWidth(newW);
            Viewport viewport2 = it.getViewport();
            Intrinsics.checkNotNullExpressionValue(newH, "newH");
            viewport2.setHeight(newH);
        }
    }

    private static final void initStage$lambda$2$lambda$0(PrimaryStageWindow this$0, WindowEvent e) {
        block0: {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            e.consume();
            Function0<Unit> function0 = this$0.getOnClose();
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    private static final void initStage$lambda$2$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    private static final void show$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    private static final void show$lambda$4(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0, p1, p2);
    }

    public static final /* synthetic */ void access$onStageResize(PrimaryStageWindow $this) {
        $this.onStageResize();
    }
}

