/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.SceneEventSubscriber;
import com.almasb.fxgl.app.scene.ErrorSubScene;
import com.almasb.fxgl.app.scene.FXGLScene;
import com.almasb.fxgl.core.fsm.State;
import com.almasb.fxgl.core.fsm.StateMachine;
import com.almasb.fxgl.input.Input;
import com.almasb.fxgl.input.MouseEventData;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.scene.CSS;
import com.almasb.fxgl.scene.Scene;
import com.almasb.fxgl.scene.SubScene;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.geometry.Point2D;
import javafx.scene.ImageCursor;
import javafx.scene.image.Image;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0017\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J!\u0010R\u001a\u0002012\u0012\u0010S\u001a\n\u0012\u0006\b\u0001\u0012\u00020U0T\"\u00020UH&\u00a2\u0006\u0002\u0010VJ8\u0010W\u001a\u0002012\u0006\u0010X\u001a\u00020Y2\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u0002010[2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020\\\u0012\u0004\u0012\u0002010[H\u0004J\u001f\u0010^\u001a\u0002012\u0012\u0010_\u001a\n\u0012\u0006\b\u0001\u0012\u00020`0T\"\u00020`\u00a2\u0006\u0002\u0010aJ$\u0010b\u001a\u0002012\u0006\u0010X\u001a\u00020Y2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u0002010[H\u0004J$\u0010d\u001a\u0002012\u0006\u0010X\u001a\u00020Y2\u0012\u0010]\u001a\u000e\u0012\u0004\u0012\u00020e\u0012\u0004\u0012\u0002010[H\u0004J\b\u0010f\u001a\u000201H&J\b\u0010g\u001a\u00020hH&J\u000e\u0010i\u001a\u00020)2\u0006\u0010\u0002\u001a\u00020\u000fJ\u0006\u0010j\u001a\u000201J\u0006\u0010k\u001a\u000201J\u000e\u0010l\u001a\u0002012\u0006\u0010m\u001a\u00020nJ\u0010\u0010o\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u000fH\u0002J\u0010\u0010p\u001a\u0002012\u0006\u0010X\u001a\u00020YH\u0004J\u0010\u0010q\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J\u0010\u0010r\u001a\u0002012\u0006\u0010s\u001a\u00020tH$J\u000e\u0010u\u001a\u0002012\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010v\u001a\u000201H&J\u0016\u0010w\u001a\u0002012\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020{J\b\u0010|\u001a\u00020`H&J\u000e\u0010}\u001a\u0002012\u0006\u0010~\u001a\u00020!R\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R,\u0010\u001a\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c`\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0012\u0010 \u001a\u00020!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0012\u0010(\u001a\u00020)X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010*R\u0014\u0010+\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\"\u0010/\u001a\n\u0012\u0004\u0012\u000201\u0018\u000100X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0014\u00106\u001a\u000207X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u000207X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00109R\u0014\u0010<\u001a\u000207X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00109R\u0014\u0010>\u001a\u000207X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00109R$\u0010@\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u001bj\b\u0012\u0004\u0012\u00020\u000f`\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u001fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0012\u0010D\u001a\u00020EX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010GR\u001a\u0010H\u001a\b\u0012\u0004\u0012\u00020\u000f0IX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010KR\u0012\u0010L\u001a\u00020!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010#R\u0012\u0010N\u001a\u00020!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010#R\u0012\u0010P\u001a\u00020!X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010#\u0082\u0001\u0003\u007f\u0080\u0001\u00a8\u0006\u0081\u0001"}, d2={"Lcom/almasb/fxgl/app/MainWindow;", "", "scene", "Lcom/almasb/fxgl/app/scene/FXGLScene;", "settings", "Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "(Lcom/almasb/fxgl/app/scene/FXGLScene;Lcom/almasb/fxgl/app/ReadOnlyGameSettings;)V", "currentFXGLScene", "getCurrentFXGLScene", "()Lcom/almasb/fxgl/app/scene/FXGLScene;", "currentFXGLSceneProperty", "Ljavafx/beans/property/ReadOnlyObjectWrapper;", "getCurrentFXGLSceneProperty", "()Ljavafx/beans/property/ReadOnlyObjectWrapper;", "currentScene", "Lcom/almasb/fxgl/scene/Scene;", "getCurrentScene", "()Lcom/almasb/fxgl/scene/Scene;", "currentSceneProperty", "getCurrentSceneProperty", "defaultCursor", "Ljavafx/scene/ImageCursor;", "getDefaultCursor", "()Ljavafx/scene/ImageCursor;", "setDefaultCursor", "(Ljavafx/scene/ImageCursor;)V", "eventSubscribers", "Ljava/util/ArrayList;", "Lcom/almasb/fxgl/app/SceneEventSubscriber;", "Lkotlin/collections/ArrayList;", "getEventSubscribers", "()Ljava/util/ArrayList;", "height", "", "getHeight", "()D", "input", "Lcom/almasb/fxgl/input/Input;", "getInput$fxgl", "()Lcom/almasb/fxgl/input/Input;", "isFocused", "", "()Z", "log", "Lcom/almasb/fxgl/logging/Logger;", "getLog", "()Lcom/almasb/fxgl/logging/Logger;", "onClose", "Lkotlin/Function0;", "", "getOnClose", "()Lkotlin/jvm/functions/Function0;", "setOnClose", "(Lkotlin/jvm/functions/Function0;)V", "scaleRatioX", "Ljavafx/beans/property/DoubleProperty;", "getScaleRatioX", "()Ljavafx/beans/property/DoubleProperty;", "scaleRatioY", "getScaleRatioY", "scaledHeight", "getScaledHeight", "scaledWidth", "getScaledWidth", "scenes", "getScenes", "getSettings", "()Lcom/almasb/fxgl/app/ReadOnlyGameSettings;", "stage", "Ljavafx/stage/Stage;", "getStage", "()Ljavafx/stage/Stage;", "stateMachine", "Lcom/almasb/fxgl/core/fsm/StateMachine;", "getStateMachine", "()Lcom/almasb/fxgl/core/fsm/StateMachine;", "width", "getWidth", "x", "getX", "y", "getY", "addCSS", "cssList", "", "Lcom/almasb/fxgl/scene/CSS;", "([Lcom/almasb/fxgl/scene/CSS;)V", "addGlobalHandler", "fxScene", "Ljavafx/scene/Scene;", "filter", "Lkotlin/Function1;", "Ljavafx/event/Event;", "handler", "addIcons", "images", "Ljavafx/scene/image/Image;", "([Ljavafx/scene/image/Image;)V", "addKeyHandler", "Ljavafx/scene/input/KeyEvent;", "addMouseHandler", "Lcom/almasb/fxgl/input/MouseEventData;", "close", "iconifiedProperty", "Ljavafx/beans/property/ReadOnlyBooleanProperty;", "isInHierarchy", "popAllSubScenes", "popState", "pushState", "newScene", "Lcom/almasb/fxgl/scene/SubScene;", "registerScene", "removeAllEventFiltersAndHandlers", "setInitialScene", "setRoot", "root", "Ljavafx/scene/layout/Pane;", "setScene", "show", "showFatalError", "error", "", "action", "Ljava/lang/Runnable;", "takeScreenshot", "update", "tpf", "Lcom/almasb/fxgl/app/EmbeddedPaneWindow;", "Lcom/almasb/fxgl/app/PrimaryStageWindow;", "fxgl"})
public abstract class MainWindow {
    @NotNull
    private final ReadOnlyGameSettings settings;
    @NotNull
    private final Logger log;
    @NotNull
    private final ReadOnlyObjectWrapper<FXGLScene> currentFXGLSceneProperty;
    @NotNull
    private final ReadOnlyObjectWrapper<Scene> currentSceneProperty;
    @Nullable
    private Function0<Unit> onClose;
    @Nullable
    private ImageCursor defaultCursor;
    @NotNull
    private final ArrayList<Scene> scenes;
    @NotNull
    private final ArrayList<SceneEventSubscriber<?>> eventSubscribers;
    @NotNull
    private final DoubleProperty scaleRatioX;
    @NotNull
    private final DoubleProperty scaleRatioY;
    @NotNull
    private final DoubleProperty scaledWidth;
    @NotNull
    private final DoubleProperty scaledHeight;
    @NotNull
    private final StateMachine<Scene> stateMachine;
    @NotNull
    private final Input input;

    private MainWindow(FXGLScene scene2, ReadOnlyGameSettings settings) {
        this.settings = settings;
        this.log = Logger.Companion.get(this.getClass());
        this.currentFXGLSceneProperty = new ReadOnlyObjectWrapper<FXGLScene>(scene2);
        this.currentSceneProperty = new ReadOnlyObjectWrapper<FXGLScene>(scene2);
        this.scenes = new ArrayList();
        this.eventSubscribers = new ArrayList();
        this.scaleRatioX = new SimpleDoubleProperty();
        this.scaleRatioY = new SimpleDoubleProperty();
        this.scaledWidth = new SimpleDoubleProperty();
        this.scaledHeight = new SimpleDoubleProperty();
        this.stateMachine = new StateMachine<State>(scene2);
        this.input = new Input();
    }

    @NotNull
    protected final ReadOnlyGameSettings getSettings() {
        return this.settings;
    }

    @NotNull
    protected final Logger getLog() {
        return this.log;
    }

    @NotNull
    public final ReadOnlyObjectWrapper<FXGLScene> getCurrentFXGLSceneProperty() {
        return this.currentFXGLSceneProperty;
    }

    @NotNull
    public final ReadOnlyObjectWrapper<Scene> getCurrentSceneProperty() {
        return this.currentSceneProperty;
    }

    @NotNull
    public final FXGLScene getCurrentFXGLScene() {
        Object t = this.currentFXGLSceneProperty.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "currentFXGLSceneProperty.value");
        return (FXGLScene)t;
    }

    @NotNull
    public final Scene getCurrentScene() {
        Object t = this.currentSceneProperty.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "currentSceneProperty.value");
        return (Scene)t;
    }

    @Nullable
    public final Function0<Unit> getOnClose() {
        return this.onClose;
    }

    public final void setOnClose(@Nullable Function0<Unit> function0) {
        this.onClose = function0;
    }

    @Nullable
    public final ImageCursor getDefaultCursor() {
        return this.defaultCursor;
    }

    public final void setDefaultCursor(@Nullable ImageCursor imageCursor) {
        this.defaultCursor = imageCursor;
    }

    @NotNull
    public abstract Stage getStage();

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public abstract boolean isFocused();

    @NotNull
    protected final ArrayList<Scene> getScenes() {
        return this.scenes;
    }

    @NotNull
    protected final ArrayList<SceneEventSubscriber<?>> getEventSubscribers() {
        return this.eventSubscribers;
    }

    @NotNull
    protected final DoubleProperty getScaleRatioX() {
        return this.scaleRatioX;
    }

    @NotNull
    protected final DoubleProperty getScaleRatioY() {
        return this.scaleRatioY;
    }

    @NotNull
    protected final DoubleProperty getScaledWidth() {
        return this.scaledWidth;
    }

    @NotNull
    protected final DoubleProperty getScaledHeight() {
        return this.scaledHeight;
    }

    @NotNull
    protected final StateMachine<Scene> getStateMachine() {
        return this.stateMachine;
    }

    @NotNull
    public final Input getInput$fxgl() {
        return this.input;
    }

    protected final void setInitialScene(@NotNull FXGLScene scene2) {
        Intrinsics.checkNotNullParameter(scene2, "scene");
        this.registerScene(scene2);
        this.currentFXGLSceneProperty.setValue(scene2);
        scene2.activeProperty().set(true);
        this.currentSceneProperty.setValue(scene2);
        this.log.debug("Set initial scene to " + scene2);
    }

    @NotNull
    public abstract ReadOnlyBooleanProperty iconifiedProperty();

    public final void addIcons(Image ... images) {
        Intrinsics.checkNotNullParameter(images, "images");
        if (!this.settings.isNative()) {
            ObservableList<Image> observableList = this.getStage().getIcons();
            Intrinsics.checkNotNullExpressionValue(observableList, "stage.icons");
            CollectionsKt.addAll((Collection)observableList, images);
        }
    }

    public abstract void addCSS(CSS ... var1);

    public final boolean isInHierarchy(@NotNull Scene scene2) {
        Intrinsics.checkNotNullParameter(scene2, "scene");
        return this.stateMachine.isInHierarchy((Scene)((State)scene2));
    }

    public final void update(double tpf) {
        this.input.update(tpf);
        this.stateMachine.runOnActiveStates(new Function1<Scene, Unit>(tpf){
            final /* synthetic */ double $tpf;
            {
                this.$tpf = $tpf;
                super(1);
            }

            public final void invoke(@NotNull Scene it) {
                Intrinsics.checkNotNullParameter(it, "it");
                it.update(this.$tpf);
            }
        });
    }

    public final void setScene(@NotNull FXGLScene scene2) {
        Intrinsics.checkNotNullParameter(scene2, "scene");
        this.popAllSubScenes();
        if (!this.scenes.contains(scene2)) {
            this.registerScene(scene2);
        }
        Scene prevScene = this.stateMachine.getParentState();
        this.stateMachine.changeState((Scene)((State)scene2));
        if (this.stateMachine.getParentState() == prevScene) {
            this.log.warning("Cannot set to " + scene2 + ". Probably because subscenes are present.");
            return;
        }
        prevScene.getInput().clearAll();
        ((FXGLScene)this.currentFXGLSceneProperty.getValue()).activeProperty().set(false);
        this.currentFXGLSceneProperty.setValue(scene2);
        this.setRoot(scene2.getRoot());
        scene2.activeProperty().set(true);
        this.currentSceneProperty.setValue(scene2);
        this.log.debug(prevScene + " -> " + scene2);
    }

    protected abstract void setRoot(@NotNull Pane var1);

    public final void pushState(@NotNull SubScene newScene) {
        Intrinsics.checkNotNullParameter(newScene, "newScene");
        this.log.debug("Push state: " + newScene);
        Scene prevScene = this.stateMachine.getCurrentState();
        this.stateMachine.changeState((Scene)((State)newScene));
        prevScene.getInput().clearAll();
        this.getCurrentFXGLScene().getContentRoot().getChildren().add(newScene.getRoot());
        this.currentSceneProperty.setValue(this.stateMachine.getCurrentState());
        this.log.debug(prevScene + " -> " + this.stateMachine.getCurrentState());
    }

    public final void popState() {
        Scene prevScene = this.stateMachine.getCurrentState();
        if (!this.stateMachine.popSubState()) {
            this.log.warning("Cannot pop substate. Probably because substates are empty!");
            return;
        }
        this.log.debug("Pop state: " + prevScene);
        prevScene.getInput().clearAll();
        this.getCurrentFXGLScene().getContentRoot().getChildren().remove(prevScene.getRoot());
        this.currentSceneProperty.setValue(this.stateMachine.getCurrentState());
        this.log.debug(this.stateMachine.getCurrentState() + " <- " + prevScene);
    }

    public final void popAllSubScenes() {
        while (this.getCurrentScene() != this.getCurrentFXGLScene()) {
            this.popState();
        }
    }

    public abstract void show();

    private final void registerScene(Scene scene2) {
        scene2.bindSize(this.scaledWidth, this.scaledHeight, this.scaleRatioX, this.scaleRatioY);
        if (!this.settings.isNative() && this.settings.isDesktop() && scene2 instanceof FXGLScene && scene2.getRoot().getCursor() == null) {
            ImageCursor imageCursor = this.defaultCursor;
            if (imageCursor != null) {
                ImageCursor it = imageCursor;
                boolean bl = false;
                FXGLScene fXGLScene = (FXGLScene)scene2;
                Image image2 = it.getImage();
                Intrinsics.checkNotNullExpressionValue(image2, "it.image");
                fXGLScene.setCursor(image2, new Point2D(it.getHotspotX(), it.getHotspotY()));
            }
        }
        this.scenes.add(scene2);
    }

    protected final void addKeyHandler(@NotNull javafx.scene.Scene fxScene, @NotNull Function1<? super KeyEvent, Unit> handler) {
        Intrinsics.checkNotNullParameter(fxScene, "fxScene");
        Intrinsics.checkNotNullParameter(handler, "handler");
        EventHandler<KeyEvent> keyHandler = arg_0 -> MainWindow.addKeyHandler$lambda$1(handler, arg_0);
        EventType<KeyEvent> eventType = KeyEvent.ANY;
        Intrinsics.checkNotNullExpressionValue(eventType, "ANY");
        this.eventSubscribers.add(new SceneEventSubscriber<KeyEvent>(fxScene, eventType, keyHandler, false));
    }

    protected final void addMouseHandler(@NotNull javafx.scene.Scene fxScene, @NotNull Function1<? super MouseEventData, Unit> handler) {
        Intrinsics.checkNotNullParameter(fxScene, "fxScene");
        Intrinsics.checkNotNullParameter(handler, "handler");
        EventHandler<MouseEvent> mouseHandler2 = arg_0 -> MainWindow.addMouseHandler$lambda$2(this, handler, arg_0);
        EventType<MouseEvent> eventType = MouseEvent.ANY;
        Intrinsics.checkNotNullExpressionValue(eventType, "ANY");
        this.eventSubscribers.add(new SceneEventSubscriber<MouseEvent>(fxScene, eventType, mouseHandler2, false));
    }

    protected final void addGlobalHandler(@NotNull javafx.scene.Scene fxScene, @NotNull Function1<? super Event, Unit> filter2, @NotNull Function1<? super Event, Unit> handler) {
        Intrinsics.checkNotNullParameter(fxScene, "fxScene");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        Intrinsics.checkNotNullParameter(handler, "handler");
        EventHandler<Event> rootFilter = arg_0 -> MainWindow.addGlobalHandler$lambda$3(filter2, arg_0);
        EventHandler<Event> rootHandler = arg_0 -> MainWindow.addGlobalHandler$lambda$4(handler, arg_0);
        EventType<Event> eventType = EventType.ROOT;
        Intrinsics.checkNotNullExpressionValue(eventType, "ROOT");
        this.eventSubscribers.add(new SceneEventSubscriber<Event>(fxScene, eventType, rootFilter, true));
        EventType<Event> eventType2 = EventType.ROOT;
        Intrinsics.checkNotNullExpressionValue(eventType2, "ROOT");
        this.eventSubscribers.add(new SceneEventSubscriber<Event>(fxScene, eventType2, rootHandler, false));
    }

    protected final void removeAllEventFiltersAndHandlers(@NotNull javafx.scene.Scene fxScene) {
        Intrinsics.checkNotNullParameter(fxScene, "fxScene");
        this.eventSubscribers.removeIf(arg_0 -> MainWindow.removeAllEventFiltersAndHandlers$lambda$5(new Function1<SceneEventSubscriber<?>, Boolean>(fxScene){
            final /* synthetic */ javafx.scene.Scene $fxScene;
            {
                this.$fxScene = $fxScene;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull SceneEventSubscriber<?> it) {
                boolean shouldRemove;
                Intrinsics.checkNotNullParameter(it, "it");
                boolean bl = shouldRemove = it.getFxScene() == this.$fxScene;
                if (shouldRemove) {
                    it.unsubscribe();
                }
                return shouldRemove;
            }
        }, arg_0));
    }

    @NotNull
    public abstract Image takeScreenshot();

    public final void showFatalError(@NotNull Throwable error, @NotNull Runnable action) {
        Intrinsics.checkNotNullParameter(error, "error");
        Intrinsics.checkNotNullParameter(action, "action");
        this.pushState(new ErrorSubScene(this.settings.getWidth(), this.settings.getHeight(), error, action));
    }

    public abstract void close();

    private static final void addKeyHandler$lambda$1(Function1 $tmp0, KeyEvent p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addMouseHandler$lambda$2(MainWindow this$0, Function1 $handler, MouseEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($handler, "$handler");
        Intrinsics.checkNotNullExpressionValue(it, "it");
        Point2D point2D = new Point2D(this$0.getCurrentFXGLScene().getContentRoot().getTranslateX(), this$0.getCurrentFXGLScene().getContentRoot().getTranslateY());
        Point2D point2D2 = new Point2D(this$0.getCurrentFXGLScene().getViewport().getX(), this$0.getCurrentFXGLScene().getViewport().getY());
        double d = this$0.getCurrentFXGLScene().getViewport().getZoom();
        Double d2 = this$0.scaleRatioX.getValue();
        Intrinsics.checkNotNullExpressionValue(d2, "scaleRatioX.value");
        double d3 = ((Number)d2).doubleValue();
        Double d4 = this$0.scaleRatioY.getValue();
        Intrinsics.checkNotNullExpressionValue(d4, "scaleRatioY.value");
        MouseEventData data = new MouseEventData(it, point2D, point2D2, d, d3, ((Number)d4).doubleValue());
        $handler.invoke(data);
    }

    private static final void addGlobalHandler$lambda$3(Function1 $tmp0, Event p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addGlobalHandler$lambda$4(Function1 $tmp0, Event p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean removeAllEventFiltersAndHandlers$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public /* synthetic */ MainWindow(FXGLScene scene2, ReadOnlyGameSettings settings, DefaultConstructorMarker $constructor_marker) {
        this(scene2, settings);
    }
}

