/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.AnimationTimerLoop;
import com.almasb.fxgl.app.Loop;
import com.almasb.fxgl.app.ScheduledExecutorLoop;
import com.almasb.fxgl.logging.Logger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\nH\u0002J\u0006\u0010\u001f\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0007J\u0006\u0010!\u001a\u00020\u0007J\u0006\u0010\"\u001a\u00020\u0007R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00038G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00068G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/almasb/fxgl/app/LoopRunner;", "", "ticksPerSecond", "", "runnable", "Lkotlin/Function1;", "", "", "(ILkotlin/jvm/functions/Function1;)V", "<set-?>", "", "cpuNanoTime", "getCpuNanoTime", "()J", "fps", "getFPS", "()I", "fpsBuffer2sec", "impl", "Lcom/almasb/fxgl/app/Loop;", "getImpl", "()Lcom/almasb/fxgl/app/Loop;", "impl$delegate", "Lkotlin/Lazy;", "lastFPSUpdateNanos", "log", "Lcom/almasb/fxgl/logging/Logger;", "tpf", "()D", "frame", "now", "pause", "resume", "start", "stop", "fxgl"})
@SourceDebugExtension(value={"SMAP\nLoopRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoopRunner.kt\ncom/almasb/fxgl/app/LoopRunner\n+ 2 Logger.kt\ncom/almasb/fxgl/logging/Logger$Companion\n+ 3 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,188:1\n157#2:189\n31#3,6:190\n*S KotlinDebug\n*F\n+ 1 LoopRunner.kt\ncom/almasb/fxgl/app/LoopRunner\n*L\n34#1:189\n102#1:190,6\n*E\n"})
public final class LoopRunner {
    private final int ticksPerSecond;
    @NotNull
    private final Function1<Double, Unit> runnable;
    @NotNull
    private final Logger log;
    private int fps;
    private double tpf;
    private long cpuNanoTime;
    private long lastFPSUpdateNanos;
    private int fpsBuffer2sec;
    @NotNull
    private final Lazy impl$delegate;

    public LoopRunner(int ticksPerSecond, @NotNull Function1<? super Double, Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, "runnable");
        this.ticksPerSecond = ticksPerSecond;
        this.runnable = runnable;
        Logger.Companion this_$iv = Logger.Companion;
        boolean $i$f$get = false;
        this.log = this_$iv.get(LoopRunner.class);
        this.fps = 60;
        this.tpf = 0.016666666666666666;
        this.impl$delegate = LazyKt.lazy((Function0)new Function0<Loop>(this){
            final /* synthetic */ LoopRunner this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Loop invoke() {
                Loop loop2;
                if (LoopRunner.access$getTicksPerSecond$p(this.this$0) <= 0) {
                    LoopRunner.access$getLog$p(this.this$0).debug("Initializing JavaFX AnimationTimerLoop");
                    loop2 = new AnimationTimerLoop(this.this$0){
                        final /* synthetic */ LoopRunner this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public void onTick(long now) {
                            LoopRunner.access$frame(this.this$0, now);
                        }
                    };
                } else {
                    LoopRunner.access$getLog$p(this.this$0).debug("Initializing ScheduledExecutorLoop with fps: " + LoopRunner.access$getTicksPerSecond$p(this.this$0));
                    int n = LoopRunner.access$getTicksPerSecond$p(this.this$0);
                    loop2 = new ScheduledExecutorLoop(this.this$0, n){
                        final /* synthetic */ LoopRunner this$0;
                        {
                            this.this$0 = $receiver;
                            super($super_call_param$1);
                        }

                        public void onTick(long now) {
                            LoopRunner.access$frame(this.this$0, now);
                        }
                    };
                }
                return loop2;
            }
        });
    }

    public /* synthetic */ LoopRunner(int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = -1;
        }
        this(n, function1);
    }

    @JvmName(name="getFPS")
    public final int getFPS() {
        return this.fps;
    }

    @JvmName(name="tpf")
    public final double tpf() {
        return this.tpf;
    }

    public final long getCpuNanoTime() {
        return this.cpuNanoTime;
    }

    private final Loop getImpl() {
        Lazy lazy = this.impl$delegate;
        return (Loop)lazy.getValue();
    }

    public final void start() {
        this.log.debug("Starting loop");
        this.getImpl().start();
    }

    public final void resume() {
        this.log.debug("Resuming loop");
        this.getImpl().resume();
    }

    public final void pause() {
        this.log.debug("Pausing loop");
        this.getImpl().pause();
        this.lastFPSUpdateNanos = 0L;
    }

    public final void stop() {
        this.log.debug("Stopping loop");
        this.getImpl().stop();
    }

    private final void frame(long now) {
        if (this.lastFPSUpdateNanos == 0L) {
            this.lastFPSUpdateNanos = now;
            this.fpsBuffer2sec = 0;
        }
        boolean $i$f$measureNanoTime = false;
        long start$iv = System.nanoTime();
        LoopRunner loopRunner = this;
        boolean bl = false;
        this.runnable.invoke(this.tpf);
        loopRunner.cpuNanoTime = System.nanoTime() - start$iv;
        int n = this.fpsBuffer2sec;
        this.fpsBuffer2sec = n + 1;
        if (now - this.lastFPSUpdateNanos >= 2000000000L) {
            this.lastFPSUpdateNanos = now;
            this.fps = this.fpsBuffer2sec / 2;
            this.fpsBuffer2sec = 0;
            if (this.fps < 5) {
                this.fps = 60;
            }
            this.tpf = 1.0 / (double)this.fps;
        }
    }

    public static final /* synthetic */ int access$getTicksPerSecond$p(LoopRunner $this) {
        return $this.ticksPerSecond;
    }

    public static final /* synthetic */ Logger access$getLog$p(LoopRunner $this) {
        return $this.log;
    }

    public static final /* synthetic */ void access$frame(LoopRunner $this, long now) {
        $this.frame(now);
    }
}

