/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.app;

import com.almasb.fxgl.app.FXGLApplication;
import com.almasb.fxgl.app.FXGLPane;
import com.almasb.fxgl.app.GameSettings;
import com.almasb.fxgl.app.ReadOnlyGameSettings;
import com.almasb.fxgl.app.RuntimeInfo;
import com.almasb.fxgl.core.reflect.ReflectionUtils;
import com.almasb.fxgl.core.util.Platform;
import com.almasb.fxgl.dev.profiling.ProfilerService;
import com.almasb.fxgl.dsl.FXGL;
import com.almasb.fxgl.logging.ConsoleOutput;
import com.almasb.fxgl.logging.FileOutput;
import com.almasb.fxgl.logging.Logger;
import com.almasb.fxgl.logging.LoggerConfig;
import com.almasb.fxgl.logging.LoggerLevel;
import java.util.Map;

public abstract class GameApplication {
    private static final Logger log = Logger.get(GameApplication.class);

    public static void launch(String[] args2) {
        try {
            GameApplication instance = GameApplication.newInstance();
            GameApplication.launch(instance, args2);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    public static void launch(Class<? extends GameApplication> appClass, String[] args2) {
        try {
            GameApplication instance = ReflectionUtils.newInstance(appClass);
            GameApplication.launch(instance, args2);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
        }
    }

    public static FXGLPane embeddedLaunch(GameApplication app) {
        try {
            ReadOnlyGameSettings settings = app.takeUserSettings();
            app.initLogger(settings);
            return FXGLApplication.embeddedLaunchFX(app, settings);
        }
        catch (Exception e) {
            GameApplication.printErrorAndExit(e);
            return null;
        }
    }

    private static void launch(GameApplication app, String[] args2) {
        ReadOnlyGameSettings settings = app.takeUserSettings();
        app.initLogger(settings);
        if (settings.isLinux()) {
            System.setProperty("quantum.multithreaded", "false");
        }
        FXGLApplication.launchFX(app, settings, args2);
    }

    private static GameApplication newInstance() {
        Class<GameApplication> appClass = ReflectionUtils.getCallingClass(GameApplication.class, "launch");
        return ReflectionUtils.newInstance(appClass);
    }

    private static void printErrorAndExit(Exception e) {
        System.out.println("Error during launch:");
        e.printStackTrace();
        System.out.println("Application will now exit");
        System.exit(-1);
    }

    private ReadOnlyGameSettings takeUserSettings() {
        GameSettings localSettings = new GameSettings();
        this.initSettings(localSettings);
        if (localSettings.isProfilingEnabled()) {
            localSettings.getEngineServices().add(ProfilerService.class);
        }
        Platform platform = Platform.get();
        if (localSettings.getRuntimeInfo().getPlatform().isBrowser()) {
            platform = Platform.BROWSER;
        }
        RuntimeInfo runtimeInfo = new RuntimeInfo(platform, "21.1", "27.03.2024 07.52");
        localSettings.setRuntimeInfo(runtimeInfo);
        localSettings.setNative(localSettings.isNative() || platform.isMobile());
        return localSettings.toReadOnly(this.getClass());
    }

    private void initLogger(ReadOnlyGameSettings settings) {
        if (settings.isFileSystemWriteAllowed() && settings.isDesktop() && !settings.isNative()) {
            Logger.addOutput(new FileOutput("FXGL"), LoggerLevel.DEBUG);
        }
        Logger.addOutput(new ConsoleOutput(), settings.getApplicationMode().getLoggerLevel());
        Logger.configure(new LoggerConfig());
        log.debug("Logging settings\n" + String.valueOf(settings));
    }

    public static void embeddedShutdown() {
        FXGL.extract$fxgl();
        Logger.removeAllOutputs();
    }

    protected abstract void initSettings(GameSettings var1);

    protected void onPreInit() {
    }

    protected void initInput() {
    }

    protected void initGameVars(Map<String, Object> vars) {
    }

    protected void initGame() {
    }

    protected void initPhysics() {
    }

    protected void initUI() {
    }

    protected void onUpdate(double tpf) {
    }
}

