/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.animation.AnimationBuilder;
import com.almasb.fxgl.core.Updatable;
import javafx.animation.Interpolator;
import javafx.util.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u000e\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u00102\u001a\u0002032\u0006\u00104\u001a\u00028\u0000H&\u00a2\u0006\u0002\u00105J\u0010\u00106\u001a\u0002032\u0006\u00107\u001a\u00020\u0016H\u0016J\u0006\u00108\u001a\u000203J\b\u00109\u001a\u000203H\u0002J\u0006\u0010:\u001a\u000203J\u000e\u0010;\u001a\u0002032\u0006\u0010<\u001a\u00020\u0016J\u0006\u0010=\u001a\u000203J\u0006\u0010>\u001a\u000203J\u0006\u0010?\u001a\u000203J\u0010\u0010@\u001a\u0002032\u0006\u00107\u001a\u00020\u0016H\u0002R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001e\u0010 \u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010!\"\u0004\b#\u0010$R\u001e\u0010%\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010!R\u001a\u0010&\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010!\"\u0004\b'\u0010$R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R\u000e\u00101\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/almasb/fxgl/animation/Animation;", "T", "Lcom/almasb/fxgl/core/Updatable;", "config", "Lcom/almasb/fxgl/animation/AnimationBuilder;", "animatedValue", "Lcom/almasb/fxgl/animation/AnimatedValue;", "(Lcom/almasb/fxgl/animation/AnimationBuilder;Lcom/almasb/fxgl/animation/AnimatedValue;)V", "getAnimatedValue", "()Lcom/almasb/fxgl/animation/AnimatedValue;", "checkDelay", "", "count", "", "cycleCount", "getCycleCount", "()I", "setCycleCount", "(I)V", "delay", "Ljavafx/util/Duration;", "<set-?>", "", "endTime", "getEndTime", "()D", "interpolator", "Ljavafx/animation/Interpolator;", "getInterpolator", "()Ljavafx/animation/Interpolator;", "setInterpolator", "(Ljavafx/animation/Interpolator;)V", "isAnimating", "()Z", "isAutoReverse", "setAutoReverse", "(Z)V", "isPaused", "isReverse", "setReverse", "onCycleFinished", "Ljava/lang/Runnable;", "getOnCycleFinished", "()Ljava/lang/Runnable;", "setOnCycleFinished", "(Ljava/lang/Runnable;)V", "onFinished", "getOnFinished", "setOnFinished", "time", "onProgress", "", "value", "(Ljava/lang/Object;)V", "onUpdate", "tpf", "pause", "resetTime", "resume", "setTimeTo", "newTime", "start", "startReverse", "stop", "updateTime", "fxgl-core"})
public abstract class Animation<T>
implements Updatable {
    @NotNull
    private final AnimatedValue<T> animatedValue;
    private boolean isAutoReverse;
    @NotNull
    private Runnable onFinished;
    @NotNull
    private Runnable onCycleFinished;
    @NotNull
    private Interpolator interpolator;
    private double time;
    private double endTime;
    private int count;
    private boolean isReverse;
    private boolean isPaused;
    private boolean isAnimating;
    @NotNull
    private final Duration delay;
    private boolean checkDelay;
    private int cycleCount;

    public Animation(@NotNull AnimationBuilder config, @NotNull AnimatedValue<T> animatedValue) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(animatedValue, "animatedValue");
        this.animatedValue = animatedValue;
        this.isAutoReverse = config.isAutoReverse();
        this.onFinished = config.getOnFinished();
        this.onCycleFinished = config.getOnCycleFinished();
        this.interpolator = config.getInterpolator();
        this.endTime = config.getDuration().toSeconds();
        this.delay = config.getDelay();
        this.checkDelay = this.delay.greaterThan(Duration.ZERO);
        this.cycleCount = config.getTimes();
    }

    @NotNull
    public final AnimatedValue<T> getAnimatedValue() {
        return this.animatedValue;
    }

    public final boolean isAutoReverse() {
        return this.isAutoReverse;
    }

    public final void setAutoReverse(boolean bl) {
        this.isAutoReverse = bl;
    }

    @NotNull
    public final Runnable getOnFinished() {
        return this.onFinished;
    }

    public final void setOnFinished(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "<set-?>");
        this.onFinished = runnable;
    }

    @NotNull
    public final Runnable getOnCycleFinished() {
        return this.onCycleFinished;
    }

    public final void setOnCycleFinished(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter(runnable, "<set-?>");
        this.onCycleFinished = runnable;
    }

    @NotNull
    public final Interpolator getInterpolator() {
        return this.interpolator;
    }

    public final void setInterpolator(@NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter(interpolator, "<set-?>");
        this.interpolator = interpolator;
    }

    public final double getEndTime() {
        return this.endTime;
    }

    public final boolean isReverse() {
        return this.isReverse;
    }

    public final void setReverse(boolean bl) {
        this.isReverse = bl;
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    public final boolean isAnimating() {
        return this.isAnimating;
    }

    public final int getCycleCount() {
        return this.cycleCount;
    }

    public final void setCycleCount(int n) {
        this.cycleCount = n;
    }

    public final void startReverse() {
        if (!this.isAnimating) {
            this.isReverse = true;
            this.start();
        }
    }

    public final void start() {
        if (!this.isAnimating) {
            this.isAnimating = true;
            this.resetTime();
            this.onProgress(this.animatedValue.getValue(this.isReverse ? 1.0 : 0.0));
        }
    }

    public final void stop() {
        if (this.isAnimating) {
            this.isAnimating = false;
            this.time = 0.0;
            this.count = 0;
            this.isReverse = false;
            this.checkDelay = this.delay.greaterThan(Duration.ZERO);
        }
    }

    public final void pause() {
        this.isPaused = true;
    }

    public final void resume() {
        this.isPaused = false;
    }

    @Override
    public void onUpdate(double tpf) {
        if (this.isPaused || !this.isAnimating) {
            return;
        }
        if (this.checkDelay) {
            this.time += tpf;
            if (this.time >= this.delay.toSeconds()) {
                this.checkDelay = false;
                this.resetTime();
                return;
            }
            return;
        }
        this.updateTime(tpf);
        if (!this.isReverse && this.time >= this.endTime || this.isReverse && this.time <= 0.0) {
            this.onProgress(this.animatedValue.getValue(this.isReverse ? 0.0 : 1.0));
            this.onCycleFinished.run();
            int n = this.count;
            this.count = n + 1;
            if (this.count >= this.cycleCount) {
                this.onFinished.run();
                this.stop();
            } else {
                if (this.isAutoReverse) {
                    this.isReverse = !this.isReverse;
                }
                this.resetTime();
            }
            return;
        }
        this.onProgress(this.animatedValue.getValue(this.time / this.endTime, this.interpolator));
    }

    private final void updateTime(double tpf) {
        this.time += this.isReverse ? -tpf : tpf;
    }

    private final void resetTime() {
        this.time = this.isReverse ? this.endTime : 0.0;
    }

    public final void setTimeTo(double newTime) {
        this.time = newTime;
        this.onProgress(this.animatedValue.getValue(this.time / this.endTime, this.interpolator));
    }

    public abstract void onProgress(T var1);
}

