/*
 * Decompiled with CFR 0.152.
 */
package com.almasb.fxgl.animation;

import com.almasb.fxgl.animation.AnimatedValue;
import com.almasb.fxgl.core.math.FXGLMath;
import javafx.animation.Interpolator;
import javafx.geometry.Point2D;
import javafx.scene.shape.QuadCurve;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J(\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/almasb/fxgl/animation/AnimatedQuadBezierPoint2D;", "Lcom/almasb/fxgl/animation/AnimatedValue;", "Ljavafx/geometry/Point2D;", "path", "Ljavafx/scene/shape/QuadCurve;", "(Ljavafx/scene/shape/QuadCurve;)V", "getPath", "()Ljavafx/scene/shape/QuadCurve;", "animate", "val1", "val2", "progress", "", "interpolator", "Ljavafx/animation/Interpolator;", "fxgl-core"})
public final class AnimatedQuadBezierPoint2D
extends AnimatedValue<Point2D> {
    @NotNull
    private final QuadCurve path;

    public AnimatedQuadBezierPoint2D(@NotNull QuadCurve path) {
        Intrinsics.checkNotNullParameter(path, "path");
        Point2D point2D = Point2D.ZERO;
        Intrinsics.checkNotNullExpressionValue(point2D, "ZERO");
        Point2D point2D2 = Point2D.ZERO;
        Intrinsics.checkNotNullExpressionValue(point2D2, "ZERO");
        super(point2D, point2D2);
        this.path = path;
    }

    @NotNull
    public final QuadCurve getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Point2D animate(@NotNull Point2D val1, @NotNull Point2D val2, double progress, @NotNull Interpolator interpolator) {
        Intrinsics.checkNotNullParameter(val1, "val1");
        Intrinsics.checkNotNullParameter(val2, "val2");
        Intrinsics.checkNotNullParameter(interpolator, "interpolator");
        Point2D point2D = FXGLMath.bezier(new Point2D(this.path.getStartX(), this.path.getStartY()), new Point2D(this.path.getControlX(), this.path.getControlY()), new Point2D(this.path.getEndX(), this.path.getEndY()), interpolator.interpolate(0.0, 1.0, progress));
        Intrinsics.checkNotNullExpressionValue(point2D, "bezier(\n                \u2026 1.0, progress)\n        )");
        return point2D;
    }
}

